<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AdminPanel extends CI_Controller {

	/**
	 * AdminPanel Controller
	 *
	 */
	 
	function __construct() {
		parent::__construct();
		session_set_cookie_params(0,'/adminpanel',DIRECT_DOMAIN,TRUE,TRUE);
		session_cache_limiter('none');
		session_start();
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);
		
		//if user is not authenticated, redirect to auth page, otherwise proceed to load controller
		if($this->session->userdata("is_loggedin") != "true") { $this->session->sess_destroy(); session_destroy(); redirect("auth/logout"); }
		
		//prev last activity update set to current last activity so we can reset it for functions we don't want to consider "activity"
		if(strlen($this->session->userdata('app_last_activity')) > 0) { $this->session->set_userdata('prev_last_activity',$this->session->userdata('app_last_activity')); }
		//if last activity not yet set, set it to current time
		else { $this->session->set_userdata('app_last_activity',time()); }
        //check if it the user needs to be logged out due to inactivity
        if(abs($this->session->userdata('app_last_activity') - time()) > (SESSION_TIMEOUT_MINS*60)) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); }    
        //update the last activity for the timeout
		else { $this->session->set_userdata('app_last_activity',time()); }
		
		//check if user has been removed since last page load
		$this->load->database();
		$user_exists = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
		//only destroy session if query successfully shows that the user no longer exists among active users
		if($user_exists) { if($user_exists->num_rows() < 1 || $user_exists->num_rows() > 1) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); } }
		
		$this->load->library("encrypt");
		$this->load->library("form_validation");
		$this->load->helper("form_helper");
		
		$ldapconfig["user"] = $this->session->userdata("username");
		$ldapconfig["pwd"] = $this->encrypt->decode($this->session->userdata("ep"));
		$this->load->library("ldap",$ldapconfig);
		
		$access_forbidden = TRUE;
		if(array_key_exists("groups",$this->session->userdata)) { 
			foreach($this->session->userdata("groups") as $group) {
				if(trim($group) == LDAP_ADMIN_GROUP1) { $access_forbidden = FALSE; }
			}
		}
		if($access_forbidden) { show_404(); }
		
		$group_mailboxes = $this->ldap->get_group_membership('uid='.$this->session->userdata('username').','.LDAP_ACCOUNTS_DN);
		$this->session->set_userdata('group_mailboxes',$group_mailboxes);
		
		$user_timezone = $this->get_user_timezone();
		if($user_timezone) {
			date_default_timezone_set($user_timezone);
		}
	} 


	public function index()
	{	
		redirect("adminpanel/reports");
	}
	
	private function log_view($action = NULL, $value = NULL) {
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		
		$data["title"] = PORTAL_TITLE_PREFIX . "Admin Panel";
		$this->load->library('locale');
		$timezone_abbrev = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		if($action == "logins") {
			$data["active_tab"] = "logins";
			if(is_null($value)) { $page_start = 0; $page = 1; }
			else { $page = $value; $page_start = (($page-1)*ADMINPANEL_LOG_DISPLAY_PER_PAGE);  }
			$logins = $this->db->query("SELECT * FROM (SELECT ROW_NUMBER() OVER (ORDER BY login_time DESC) AS RowNum, * FROM logins) AS rows WHERE RowNum > " . ($page_start) . " AND RowNum <= " . ($page_start + ADMINPANEL_LOG_DISPLAY_PER_PAGE) . " ORDER BY RowNum");
			$log_count_query = $this->db->query("SELECT COUNT(id) AS login_count FROM logins");
			if($logins && $log_count_query) {
				$row = $log_count_query->row_array();
				$log_count = $row["login_count"];
				$view_str = "<span style=\"float: right;\"><a href=\"javascript:exportCSV('logins');\">Export</a></span>";
				$view_str .= "<h2>System Logs &#8594; Login Logs</h2>";
				$view_str .= $this->generate_pagination($page,$log_count,ADMINPANEL_LOG_DISPLAY_PER_PAGE,'/adminpanel/logs/logins/');
				$view_str .= "<table class=\"log\">";
				$view_str .= '<caption class="hidden_context">Log of Login Records</caption>';
				$view_str .= "<tr><th>Log Date";
				if(isset($timezone_abbrev)) { $view_str .= ' (' . $timezone_abbrev .')'; }
				$view_str .= "</th><th>Username</th><th>IP Address</th><th>Login Success</th><th>Error Message</th></tr>";
				for($i = 0; $i < $logins->num_rows(); $i++) {
					$row = $logins->row_array($i);
					if($row["success"]) { $success = "Success"; } else { $success = "Failure"; }
					$view_str .= "<tr><td>" . htmlentities(date("m/d/y h:i:s A",$row["login_time"])) . "</td><td>" . htmlentities($row["username"]) . "</td><td>" . htmlentities($row["ip_address"]) . "</td><td>" . $success . "</td><td>" . htmlentities($row["error_msg"]) . "</td></tr>";
				}
				$view_str .= "</table>";
			}
		}
		else if($action == "sent_mail") {
			$data["active_tab"] = "sent_mail";
			if(is_null($value)) { $page_start = 0; $page = 1; }
			else { $page = $value; $page_start = (($page-1)*ADMINPANEL_LOG_DISPLAY_PER_PAGE);  }
			$sent_mail = $this->db->query("SELECT * FROM (SELECT ROW_NUMBER() OVER (ORDER BY time DESC) AS RowNum, * FROM mail_log WHERE inbound_outbound=0) AS rows WHERE inbound_outbound = 0 AND RowNum > " . ($page_start) . " AND RowNum <= " . ($page_start + ADMINPANEL_LOG_DISPLAY_PER_PAGE) . " ORDER BY RowNum");
			$log_count_query = $this->db->query("SELECT COUNT(id) AS sent_count FROM mail_log WHERE inbound_outbound=0");
			if($sent_mail && $log_count_query) {
				$row = $log_count_query->row_array();
				$log_count = $row["sent_count"];
				$view_str = "<span style=\"float: right;\"><a href=\"javascript:exportCSV('sent_mail');\">Export</a></span>";
				$view_str .= "<h2>System Logs &#8594; Sent Mail Logs</h2>";
				$view_str .= $this->generate_pagination($page,$log_count,ADMINPANEL_LOG_DISPLAY_PER_PAGE,'/adminpanel/logs/sent_mail/');
				$view_str .= "<table class=\"log\">";
				$view_str .= '<caption class="hidden_context">Log of Sent Mail</caption>';
				$view_str .= "<tr><th>Log Date";
				if(isset($timezone_abbrev)) { $view_str .= ' (' . $timezone_abbrev .')'; }
				$view_str .="</th><th>Sender</th><th>Recipient(s)</th><th>Message Size (KB)</th><th>Send Success</th></tr>";
				for($i = 0; $i < $sent_mail->num_rows(); $i++) {
					$row = $sent_mail->row_array($i);
					if($row["success"]) { $success = "Success"; } else { $success = "Failure"; }
					$view_str .= "<tr><td>" . htmlentities(date("m/d/y h:i:s A",$row["time"])) . "</td><td>" . htmlentities($row["sender"]) . "</td><td>" . htmlentities(implode(", ",json_decode($row["recipient"]))) . "</td><td>" . $row["size"] . "</td><td>" . $success . "</td></tr>";
				}
				$view_str .= "</table>";
			}
		}
		else if($action == "received_mail") {
			$data["active_tab"] = "received_mail";
			if(is_null($value)) { $page_start = 0; $page = 1; }
			else { $page = $value; $page_start = (($page-1)*ADMINPANEL_LOG_DISPLAY_PER_PAGE);  }
			$sent_mail = $this->db->query("SELECT * FROM (SELECT ROW_NUMBER() OVER (ORDER BY time DESC) AS RowNum, * FROM mail_log WHERE inbound_outbound=1) AS rows WHERE inbound_outbound = 1 AND RowNum > " . ($page_start) . " AND RowNum <= " . ($page_start + ADMINPANEL_LOG_DISPLAY_PER_PAGE) . " ORDER BY RowNum");
			$log_count_query = $this->db->query("SELECT COUNT(id) AS sent_count FROM mail_log WHERE inbound_outbound=1");
			if($sent_mail && $log_count_query) {
				$row = $log_count_query->row_array();
				$log_count = $row["sent_count"];
				$view_str = "<span style=\"float: right;\"><a href=\"javascript:exportCSV('received_mail');\">Export</a></span>";
				$view_str .= "<h2>System Logs &#8594; Received Mail Logs</h2>";
				$view_str .= $this->generate_pagination($page,$log_count,ADMINPANEL_LOG_DISPLAY_PER_PAGE,'/adminpanel/logs/received_mail/');
				$view_str .= "<table class=\"log\">";
				$view_str .= '<caption class="hidden_context">Log of Received Mail</caption>';
				$view_str .= "<tr><th>Log Date";
				if(isset($timezone_abbrev)) { $view_str .= ' (' . $timezone_abbrev .')'; }
				$view_str .="</th><th>Sender</th><th>Recipient(s)</th><th>Message Size (KB)</th><th>Receipt Success</th></tr>";
				for($i = 0; $i < $sent_mail->num_rows(); $i++) {
					$row = $sent_mail->row_array($i);
					if($row["success"]) { $success = "Success"; } else { $success = "Failure"; }
					$view_str .= "<tr><td>" . htmlentities(date("m/d/y h:i:s A",$row["time"])) . "</td><td>" . htmlentities($row["sender"]) . "</td><td>" . htmlentities(implode(", ",json_decode($row["recipient"]))) . "</td><td>" . $row["size"] . "</td><td>" . $success . "</td></tr>";
				}
				$view_str .= "</table>";
			}
		}
		else if($action == "edit") {
			$data["active_tab"] = "edit";
			if(is_null($value)) { $page_start = 0; $page = 1; }
			else { $page = $value; $page_start = (($page-1)*ADMINPANEL_LOG_DISPLAY_PER_PAGE);  }
			$edits = $this->db->query("SELECT * FROM (SELECT ROW_NUMBER() OVER (ORDER BY edit_datetime DESC) AS RowNum, * FROM edit_log) AS rows WHERE RowNum > " . ($page_start) . " AND RowNum <= " . ($page_start + ADMINPANEL_LOG_DISPLAY_PER_PAGE) . " ORDER BY RowNum");
			$log_count_query = $this->db->query("SELECT COUNT(edit_id) AS edit_count FROM edit_log");
			if($edits && $log_count_query) {
				$row = $log_count_query->row_array();
				$log_count = $row["edit_count"];
				$view_str = "<span style=\"float: right;\"><a href=\"javascript:exportCSV('edit');\">Export</a></span>";
				$view_str .= "<h2>System Logs &#8594; User Edit Logs</h2>";
				$view_str .= $this->generate_pagination($page,$log_count,ADMINPANEL_LOG_DISPLAY_PER_PAGE,'/adminpanel/logs/edit/');
				$view_str .= "<table class=\"log\">";
				$view_str .= '<caption class="hidden_context">Log of Edit Records</caption>';
				$view_str .= "<tr><th>Log Date";
				if(isset($timezone_abbrev)) { $view_str .= ' (' . $timezone_abbrev .')'; }
				$view_str .= "</th><th>Target</th><th>Actor</th><th>Action</th></tr>";
				for($i = 0; $i < $edits->num_rows(); $i++) {
					$row = $edits->row_array($i);
					$target_id_query = $this->db->query("SELECT user_name FROM users WHERE user_id=" . $this->db->escape($row["target_user_id"]));
					$actor_id_query = $this->db->query("SELECT user_name FROM users WHERE user_id=" . $this->db->escape($row["actor_user_id"]));
					if($target_id_query && $actor_id_query) {
						$target_id_row = $target_id_query->row_array();
						$actor_id_row = $actor_id_query->row_array();
						$target_name = isset($target_id_row ["user_name"]) ? $target_id_row ["user_name"] : "Unknown User";
						$actor_name = isset($actor_id_row ["user_name"]) ? $actor_id_row ["user_name"] : "Unknown User";
						$view_str .= "<tr><td>" . htmlentities(date("m/d/y h:i:s A",$row["edit_datetime"])) . "</td><td>" . htmlentities($target_name) . "</td><td>" . htmlentities($actor_name) . "</td><td>" . htmlentities($row["edit_action"]) . "</td></tr>";
					}
				}
				$view_str .= "</table>";
			}
		}
		else if($action == "feedback") {
			$data["active_tab"] = "feedback";
			if(is_null($value)) { $page_start = 0; $page = 1; }
			else { $page = $value; $page_start = (($page-1)*ADMINPANEL_LOG_DISPLAY_PER_PAGE);  }
			$feedback = $this->db->query("SELECT * FROM (SELECT ROW_NUMBER() OVER (ORDER BY feedback_id DESC) AS RowNum, * FROM feedback) AS rows WHERE RowNum > " . ($page_start) . " AND RowNum <= " . ($page_start + ADMINPANEL_LOG_DISPLAY_PER_PAGE) . " ORDER BY RowNum");
			$log_count_query = $this->db->query("SELECT COUNT(feedback_id) AS feedback_count FROM feedback");
			if($feedback && $log_count_query) {
				$row = $log_count_query->row_array();
				$log_count = $row["feedback_count"];
				$view_str = "<span style=\"float: right;\"><a href=\"javascript:exportCSV('feedback');\">Export</a></span>";
				$view_str .= "<h2>System Logs &#8594; User Feedback Logs</h2>";
				$view_str .= $this->generate_pagination($page,$log_count,ADMINPANEL_LOG_DISPLAY_PER_PAGE,'/adminpanel/logs/feedback/');
				$view_str .= "<table class=\"log\">";
				$view_str .= '<caption class="hidden_context">Log of Feedback Records</caption>';
				$view_str .= "<tr><th>Log Date";
				if(isset($timezone_abbrev)) { $view_str .= ' (' . $timezone_abbrev .')'; }
				$view_str .= "</th><th>Username</th><th>Feedback Type</th><th>Feedback Comments</th></tr>";
				for($i = 0; $i < $feedback->num_rows(); $i++) {
					$row = $feedback->row_array($i);
					$actor_id_query = $this->db->query("SELECT user_name FROM users WHERE user_id=" . $this->db->escape($row["user_id"]));
					if($actor_id_query) {
						$actor_id_row = $actor_id_query->row_array();
						$actor_name = $actor_id_row ["user_name"];
						$view_str .= "<tr><td>" . htmlentities(date("m/d/y h:i:s A",$row["feedback_datetime"])) . "</td><td>" . htmlentities($actor_name) . "</td><td>" . htmlentities($row["feedback_type"]) . "</td><td>" . htmlentities($row["feedback_comments"]) . "</td></tr>";
					}
				}
				$view_str .= "</table>";
			}
		}
		else { show_404(); }
		$data["log_view"] = $view_str;
		return $data;
	}
	/*load log view */
	function logs($action = NULL, $value = NULL) {
		if(is_null($action)) { 
			redirect("adminpanel/logs/logins");
		}
		else {
			$data = $this->log_view($action,$value);
			$this->load->view("adminpanel/logs",$data);
		}
	}
	
	/*This function displays the export form view, meant for use with modal window or pop-up */
	public function export_form($log) {
		$this->load->view('adminpanel/export_form',array('log'=>$log));
	}
	
	/* This function exports a log for a given time period to csv format
	 */
	public function export($log) {
		$this->load->library('locale');
		$timezone_abbrev = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
		
		$start_date = $this->input->post("start_date",TRUE);
		$end_date = $this->input->post("end_date",TRUE);
		$start_udate = strtotime($start_date);
		$end_udate = strtotime($end_date) ? strtotime($end_date) + 86400 : strtotime($end_date);
		$this->load->model('webmailmodel');
		$log_query = $this->webmailmodel->get_log_export($log,$start_udate,$end_udate);
		
		if($log == "logins") {
			if($log_query) {
                header('Content-Type: application/download'); 
				header("Content-Transfer-Encoding: binary");
				header('Content-Disposition: attachment; filename="logins.csv"');
				echo "FOR OFFICIAL USE ONLY\n";
				echo "Log Date";
				if(isset($timezone_abbrev)) { echo ' (' . $timezone_abbrev . ')'; }
				echo ",Username,IP Address,Login Success,Error Message\n";
				for($i = 0; $i < $log_query->num_rows(); $i++) {
					$row = $log_query->row_array($i);
					foreach($row as $key => $val) { $row[$key] = str_replace("\"","\"\"",$val); }
					if($row["success"]) { $success = "Success"; } else { $success = "Failure"; }
					echo date("m/d/y h:i:s A",$row["login_time"]) . ",\"" . $row["username"] . "\"," . $row["ip_address"] . "," . $success . ",\"" . $row["error_msg"] . "\"\n";
				}
			}
		}
		else if($log == "sent_mail") {
			if($log_query) {
				header('Content-Type: application/download'); 
				header("Content-Transfer-Encoding: binary");
                header('Content-Disposition: attachment; filename="sent_mail.csv"');
				echo "FOR OFFICIAL USE ONLY\n";
				echo "Log Date";
				if(isset($timezone_abbrev)) { echo ' (' . $timezone_abbrev . ')'; }
				echo ",Sender,Recipient(s),Message Size (KB),Send Success\n";
				for($i = 0; $i < $log_query->num_rows(); $i++) {
					$row = $log_query->row_array($i);
					if($row["success"]) { $success = "Success"; } else { $success = "Failure"; }
					echo date("m/d/y h:i:s A",$row["time"]) . ",\"" . $this->sanatize_export($row["sender"]) . "\",\"" . implode(", ",$this->sanatize_export(json_decode($row["recipient"]))) . "\"," . $row["size"] . "," . $success . "\n";
				}
			}
		}
		else if($log == "received_mail") {
			if($log_query) {
				header('Content-Type: application/download'); 
				header("Content-Transfer-Encoding: binary");
                header('Content-Disposition: attachment; filename="received_mail.csv"');
				echo "FOR OFFICIAL USE ONLY\n";
				echo "Log Date";
				if(isset($timezone_abbrev)) { echo ' (' . $timezone_abbrev . ')'; }
				echo ",Sender,Recipient(s),Message Size (KB),Receipt Success\n";
				for($i = 0; $i < $log_query->num_rows(); $i++) {
					$row = $log_query->row_array($i);
					if($row["success"]) { $success = "Success"; } else { $success = "Failure"; }
					echo date("m/d/y h:i:s A",$row["time"]) . ",\"" . $this->sanatize_export($row["sender"]) . "\",\"" . implode(", ",$this->sanatize_export(json_decode($row["recipient"]))) . "\"," . $row["size"] . "," . $success . "\n";
				}
			}
		}
		else if($log == "edit") {
			if($log_query) {
				header('Content-Type: application/download'); 
				header("Content-Transfer-Encoding: binary");
                header('Content-Disposition: attachment; filename="edit_log.csv"');
				echo "FOR OFFICIAL USE ONLY\n";
				echo "Log Date";
				if(isset($timezone_abbrev)) { echo ' (' . $timezone_abbrev . ')'; }
				echo ",Target,Actor,Action\n";
				for($i = 0; $i < $log_query->num_rows(); $i++) {
					$row = $log_query->row_array($i);
					$target_id_query = $this->db->query("SELECT user_name FROM users WHERE user_id=" . $this->db->escape($row["target_user_id"]));
					$actor_id_query = $this->db->query("SELECT user_name FROM users WHERE user_id=" . $this->db->escape($row["actor_user_id"]));
					if($target_id_query && $actor_id_query) {
						$target_id_row = $target_id_query->row_array();
						$actor_id_row = $actor_id_query->row_array();
						$target_name = isset($target_id_row ["user_name"]) ? $target_id_row ["user_name"] : "Unknown User";
						$actor_name = isset($actor_id_row ["user_name"]) ? $actor_id_row ["user_name"] : "Unknown User";
						echo date("m/d/y h:i:s A",$row["edit_datetime"]) . ",\"" . $this->sanatize_export($target_name) . "\",\"" . $this->sanatize_export($actor_name) . "\"," . $this->sanatize_export($row["edit_action"]) . "\n";
					}
				}
			}
		}
		else if($log == "feedback") {
			if($log_query) {
				header('Content-Type: application/download'); 
				header("Content-Transfer-Encoding: binary");
                header('Content-Disposition: attachment; filename="feedback.csv"');
				echo "FOR OFFICIAL USE ONLY\n";
				echo "Log Date";
				if(isset($timezone_abbrev)) { echo ' (' . $timezone_abbrev . ')'; }
				echo ",Username,Feedback Type,Feedback Comments\n";
				for($i = 0; $i < $log_query->num_rows(); $i++) {
					$row = $log_query->row_array($i);
					$actor_id_query = $this->db->query("SELECT user_name FROM users WHERE user_id=" . $this->db->escape($row["user_id"]));
					if($actor_id_query) {
						$actor_id_row = $actor_id_query->row_array();
						$actor_name = isset($actor_id_row["user_name"]) ? $actor_id_row["user_name"] : "Unknown User";
						echo date("m/d/y h:i:s A",$row["feedback_datetime"]) . ",\"" . $this->sanatize_export($actor_name) . "\",\"" . $this->sanatize_export($row["feedback_type"]) . "\"," . $this->sanatize_export($row["feedback_comments"]) . "\n";
					}
				}
			}
		}
		else { show_404(); }
	}
	/* This function loads statistics from the database into html tables which are then converted into
	 * chart visualizations by a jquery library 
	 */
	public function chart($chart = NULL) {
		$data["title"] = PORTAL_TITLE_PREFIX . "Admin Panel";
		
		if(is_null($chart)) { $chart = "sent_messages"; }
		switch ($chart) {
			case "sent_messages":
					//create total messages sent per day chart
					$stmt = $this->db->query("SELECT time AS date, COUNT(time) AS msg_count FROM mail_log WHERE inbound_outbound=0 AND time BETWEEN (datediff(ss, '19700101', GetUtcDate()) - 518400) AND (datediff(ss, '19700101', GetUtcDate())) GROUP BY time");
					$i = 0;
					$chartdata = array();
					$results = array();
					foreach($stmt->result_array() as $row) {
						$date = date("m/d", $row['date']);
						$count = $row['msg_count'];
						if(array_key_exists($date,$results)) { $results[$date] = $results[$date] + $count; }
						else { $results[$date] = $count; }
					}
					foreach($results as $key => $row) {
						$chartdata[$i]["date"] = $key;
						$chartdata[$i]["count"] = $row;
						$i++;
					}
					//add dates with no records to chart
					$j = 0;
				for($i = (date("U") - (86400*6)); $i <= date("U"); $i = $i + 86400) {
					if(isset($chartdata[$j]) && $chartdata[$j]["date"] != date("m/d",$i)) { array_splice($chartdata,$j,0,array(array("date" => date("m/d",$i), "count" => 0))); }
					else if(!isset($chartdata[$j])){ $chartdata[$j]["date"] = date("m/d",$i); $chartdata[$j]["count"] = 0; }
					$j++;
				}
				$data['chart_title'] = 'Messages Sent Daily Chart';
				$data["chart"] = $this->createJQueryChart("line","Messages Sent Daily",$chartdata, "sent_daily_chart","650px","325px");
				$data['hidden_chart'] = '<table><caption>Table representing data in Messages Sent Daily chart</caption><tr><th>Date</th><th>Messages Sent</th></tr>';
				foreach($chartdata as $cdata) {
					$data['hidden_chart'] .= '<tr><td>' . $cdata['date'] . '</td><td>' . $cdata['count'] . '</td></tr>';
				}
				$data['hidden_chart'] .= '</table>';
				break;
			case "message_success":
				//create success vs fail sent messages chart
				$stmt = $this->db->query("SELECT SUM(CASE WHEN success = 1 THEN 1 ELSE 0 END) AS success, SUM(CASE WHEN success = 0 THEN 1 ELSE 0 END) AS fail FROM mail_log WHERE inbound_outbound=0");
				$chartdata = array();
				foreach($stmt->result_array() as $row) {
					$chartdata["success"]["label"] = "Succeeded";
					$chartdata["success"]["val"] = $row['success'];
					$chartdata["fail"]["label"] = "Failed"; 
					$chartdata["fail"]["val"] = $row['fail']; 
				}
				$data['chart_title'] = 'Send Success/Failure Chart';
				$data["chart"] = $this->createJQueryChart("pie","Send Success/Failure",$chartdata, "success_fail_chart", "650px","325px","['#0162A2','#FFA500']");
				$data['hidden_chart'] = '<table>';
				$data['hidden_chart'] .= '<caption>Table representing data in Send Success/Failure chart</caption>';
				$data['hidden_chart'] .= '<tr><th scope="col">Data Type</th><th scope="col">' . $chartdata['success']['label'] . '</th><th scope="col">' . $chartdata['fail']['label'] . '</th></tr>'; 
				$data['hidden_chart'] .= '<tr><th scope="row">Count</th><td>' . $chartdata['success']['val'] . '</td><td>' . $chartdata['fail']['val'] . '</td></tr>';
				$data['hidden_chart'] .= '<tr><th scope="row">Percentage of Total</th><td>' . round((($chartdata['success']['val']/($chartdata['success']['val']+$chartdata['fail']['val']))*100),2).'%'.'</td><td>' . round((($chartdata['fail']['val']/($chartdata['success']['val']+$chartdata['fail']['val']))*100),2).'%'. '</td></tr>';
				$data['hidden_chart'] .= '</table>';
				break;
			case "average_size":
				//create average message size per day chart
				$stmt = $this->db->query("SELECT time AS date, AVG(size) AS msg_size FROM mail_log WHERE inbound_outbound=0 AND time BETWEEN (datediff(ss, '19700101', GetUtcDate()) - 518400) AND (datediff(ss, '19700101', GetUtcDate())) GROUP BY time");
				$chartdata = array();
				$results = array();
				foreach($stmt->result_array() as $row) {
						$date = date("m/d", $row['date']);
						$size = $row['msg_size'];
						if(array_key_exists($date,$results)) { 
							$results[$date]['size'] = $results[$date]['size'] + $size; 
							$results[$date]['count'] = $results[$date]['count'] + 1;
						}
						else { $results[$date]['size'] = $size; $results[$date]['count'] = 1; }
				}
				$i = 0;
				foreach($results as $key => $row) {
					$chartdata[$i]["date"] = $key;
					$chartdata[$i]["size"] = round(($row['size'] / $row['count']),2);
					$i++;
				}
				//add dates with no records to chart
				$j = 0;
				for($i = (date("U") - (86400*6)); $i <= date("U"); $i = $i + 86400) {
					if(isset($chartdata[$j]) && $chartdata[$j]["date"] != date("m/d",$i)) { array_splice($chartdata,$j,0,array(array("date" => date("m/d",$i), "size" => 0))); }
					else if(!isset($chartdata[$j])){ $chartdata[$j]["date"] = date("m/d",$i); $chartdata[$j]["size"] = 0; }
					$j++;
				}
				$data['chart_title'] = 'Avg. Daily Message Size (KB) Chart';
				$data["chart"] = $this->createJQueryChart("line","Avg. Daily Message Size (KB)",$chartdata, "avg_size_chart","650px","325px");
				$data['hidden_chart'] = '<table><caption>Table representing data in Average Daily Message Size chart</caption><tr><th>Date</th><th>Size (KB)</th></tr>';
				foreach($chartdata as $cdata) {
					$data['hidden_chart'] .= '<tr><td>' . $cdata['date'] . '</td><td>' . $cdata['size'] . '</td></tr>';
				}
				$data['hidden_chart'] .= '</table>';
				break;
			case "unique_logins":
				//create unique logins per day chart
				$stmt = $this->db->query("SELECT login_time AS date, username, ip_address FROM logins WHERE success=1 AND (login_time BETWEEN (datediff(ss, '19700101', GetUtcDate()) - 518400) AND (datediff(ss, '19700101', GetUtcDate())))");
				$chartdata = array();
				$results = array();
				foreach($stmt->result_array() as $row) {
						$date = date("m/d", $row['date']);
						$username = $row['username'];
						$ip = $row['ip_address'];
						$user_ip = $username . '#' . $ip;
						if(array_key_exists($date,$results)) {
							if(array_key_exists($user_ip,$results[$date])) {
								$results[$date][$user_ip]['count'] = $results[$date][$user_ip]['count'] + 1;
							}
							else { $results[$date][$user_ip]['count'] = 1; }
						}
						else { 
							$results[$date][$user_ip]['count'] = 1;
						}
				}
				foreach($results as $date => $logins) {
					$day_count = 0;
					foreach($logins as $user_ip) {
						$day_count++;
					}
					$results[$date]['count'] = $day_count;
				}
				$i = 0;
				foreach($results as $key => $row) {
					$chartdata[$i]["date"] = $key;
					$chartdata[$i]["count"] = $row['count'];
					$i++;
				}
				
				//add dates with no records to chart
				$j = 0;
				for($i = (date("U") - (86400*6)); $i <= date("U"); $i = $i + 86400) {
					if(isset($chartdata[$j]) && $chartdata[$j]["date"] != date("m/d",$i)) { array_splice($chartdata,$j,0,array(array("date" => date("m/d",$i), "count" => 0))); }
					else if(!isset($chartdata[$j])){ $chartdata[$j]["date"] = date("m/d",$i); $chartdata[$j]["count"] = 0; }
					$j++;
				}
				$data['chart_title'] = 'Unique Successful Logins Daily Chart';
				$data["chart"] = $this->createJQueryChart("bar","Unique Successful Logins Daily",$chartdata, "unique_login_chart","650px","325px","['blue']");
				$data['hidden_chart'] = '<table><caption>Table representing data in Unique Successful Logins Daily chart</caption><tr><th>Date</th><th>Login Count</th></tr>';
				foreach($chartdata as $cdata) {
					$data['hidden_chart'] .= '<tr><td>' . $cdata['date'] . '</td><td>' . $cdata['count'] . '</td></tr>';
				}
				$data['hidden_chart'] .= '</table>';
				break;
			case "login_success":
				//create success vs fail login chart
				$stmt = $this->db->query("SELECT SUM(CASE WHEN success = 1 THEN 1 ELSE 0 END) AS success, SUM(CASE WHEN success = 0 THEN 1 ELSE 0 END) AS fail FROM logins");
				$chartdata = array();
				foreach($stmt->result_array() as $row) {
					$chartdata["success"]["label"] = "Succeeded";
					$chartdata["success"]["val"] = $row['success'];
					$chartdata["fail"]["label"] = "Failed"; 
					$chartdata["fail"]["val"] = $row['fail']; 
				}
				$data['chart_title'] = 'Login Success/Failure Chart';
				$data["chart"] = $this->createJQueryChart("pie","Login Success/Failure",$chartdata, "login_success_fail_chart", "650px","325px","['#0162A2','#FFA500']");
				$data['hidden_chart'] = '<table>';
				$data['hidden_chart'] .= '<caption>Table representing data in Login Success/Failure chart</caption>';
				$data['hidden_chart'] .= '<tr><th scope="col">Data Type</th><th scope="col">' . $chartdata['success']['label'] . '</th><th scope="col">' . $chartdata['fail']['label'] . '</th></tr>'; 
				$data['hidden_chart'] .= '<tr><th scope="row">Count</th><td>' . $chartdata['success']['val'] . '</td><td>' . $chartdata['fail']['val'] . '</td></tr>';
				$data['hidden_chart'] .= '<tr><th scope="row">Percentage of Total</th><td>' . round((($chartdata['success']['val']/($chartdata['success']['val']+$chartdata['fail']['val']))*100),2).'%'.'</td><td>' . round((($chartdata['fail']['val']/($chartdata['success']['val']+$chartdata['fail']['val']))*100),2).'%'. '</td></tr>';
				$data['hidden_chart'] .= '</table>';
				break;
			case "login_errors":
				//create failed login error chart
				$stmt = $this->db->query("SELECT TOP(5) username, error_msg FROM logins WHERE success = 0 ORDER BY login_time DESC");
				$chartdata = array();
				$i = 0;
				foreach($stmt->result_array() as $row) {
					$chartdata[$i]["username"] = $row['username'];
					$chartdata[$i]["error"] = $row['error_msg'];
					$i++;
				}
				$data['chart_title'] = 'Recent Login Failure Reasons Chart';
				$data["chart"] = $this->createJQueryChart("table","Recent Login Failure Reasons",$chartdata, "failed_login_chart", "650px","325px","",FALSE);
				$data['hidden_chart'] = '';
				break;
			case "attachment_types":
				//create unique attachment types chart
				$stmt = $this->db->query("SELECT attachment_types FROM mail_log");
				$chartdata = array();
				foreach($stmt->result_array() as $row) {
					if(strlen(trim($row["attachment_types"])) > 0) { 
						$counts = array_count_values(explode(" ",trim($row["attachment_types"])));
						foreach($counts as $key => $count) { 
							if(!array_key_exists($key,$chartdata)) { 
								$chartdata[$key]["type"] = $key;
								$chartdata[$key]["count"] = $count; 
							}	 
							else { 
								$chartdata[$key]["type"] = $key;
								$chartdata[$key]["count"] = $chartdata[$key]["count"] + $count;
							}	
						}
					}
					else if(strlen(trim($row["attachment_types"])) == 0) {
						if(!array_key_exists("none",$chartdata)) { 
							$chartdata["none"]["type"] = "none";
							$chartdata["none"]["count"] = 0;
						}
						else { 
							$chartdata["none"]["type"] = "none";
							$chartdata["none"]["count"] = $chartdata["none"]["count"] + 1;
						}
					}
				}
				$data['chart_title'] = 'Unique Attachment Type Volumes Chart';
				$data["chart"] = $this->createJQueryChart("bar","Unique Attachment Type Volumes",$chartdata,"unique_attachments_chart","650px","325px","['blue']");
				$data['hidden_chart'] = '<table><caption>Table representing data in Unique Attachment Type Volumes chart</caption><tr><th>Type</th><th>Attachment Count</th></tr>';
				foreach($chartdata as $cdata) {
					$data['hidden_chart'] .= '<tr><td>' . $cdata['type'] . '</td><td>' . $cdata['count'] . '</td></tr>';
				}
				$data['hidden_chart'] .= '</table>';
				break;
			default:
				$data["chart"] = "Unrecognized chart type";
				break;
		}
		//load view
		$this->load->view("adminpanel/chart",$data);
	}
	public function reports() {
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		
		$data["title"] = PORTAL_TITLE_PREFIX . "Admin Panel";
		$this->load->view("adminpanel/reports",$data);
	}
	
	public function themes($action = NULL) {
		if(is_null($action)) {
			$this->load->model('webmailmodel');
			$get_theme = $this->webmailmodel->get_user_theme_info();
			$data['get_theme'] = $get_theme;
			
			$data["title"] = PORTAL_TITLE_PREFIX . "Admin Panel";
			$get_themes = $this->db->query("SELECT * FROM themes");
			$data["themes"] = array();
			if($get_themes) {
				for($i = 0; $i < $get_themes->num_rows(); $i++) {
					array_push($data["themes"],$get_themes->row_array($i));
				}
			}
			$this->load->view("adminpanel/themes",$data);
		}
		//TO-DO: These else statements on failure should lead to error message given to user
		else if($action == "load_theme") {
			$theme_id = $this->input->post("theme_id",TRUE);
			$check_theme =  $this->db->query("SELECT theme_id FROM themes WHERE theme_id = " . $this->db->escape($theme_id));
			if($check_theme->num_rows() > 0) {
				$update_default_theme = $this->db->query("UPDATE themes SET theme_is_default=0 WHERE theme_id !=" . $this->db->escape($theme_id));
				if($update_default_theme) {
					$update_default_theme = $this->db->query("UPDATE themes SET theme_is_default=1 WHERE theme_id=" . $this->db->escape($theme_id));
					if($update_default_theme) { 
						$update_theme = $this->db->query("UPDATE users SET user_theme=" . $this->db->escape($theme_id));
						if($update_theme) {
							redirect("adminpanel/themes");
						}
						else { redirect("adminpanel/themes"); }
					}
					else { redirect("adminpanel/themes"); }
				}
			}
			else { redirect("adminpanel/themes"); }
		}
		else { show_404(); }
	}	
	
	/*This function creates a view with which to view and edit users
	 */
	public function manage_users($action = NULL, $value = NULL) {
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		
		$data["title"] = PORTAL_TITLE_PREFIX . "Admin Panel";
		if(is_null($action)) { $action = "page"; }
		if($action == "page") {
			if(is_null($value)) { $data['page_start'] = 0; $data['page'] = 1; }
			else { $data['page'] = $value; $data['page_start'] = (($data['page']-1)*ADMINPANEL_DISPLAY_PER_PAGE);  }

			$get_user_count = $this->db->query("SELECT COUNT(user_name) AS count FROM users WHERE user_deleted_flag=0 AND user_is_group=0");
			if($get_user_count) {
				$user_count_arr = $get_user_count->row_array();
				$data['user_count'] = $user_count_arr["count"];
				$get_users = $this->db->query("SELECT user_name FROM (SELECT ROW_NUMBER() OVER (ORDER BY user_name) AS RowNum, user_name,user_deleted_flag,user_is_group FROM users WHERE user_deleted_flag = 0 AND user_is_group=0) AS rows WHERE user_deleted_flag=0 AND user_is_group=0 AND RowNum > " . ($data['page_start']) . " AND RowNum <= " . ($data['page_start'] + ADMINPANEL_DISPLAY_PER_PAGE) . " ORDER BY RowNum");
				if($get_users) {
					for($i = 0; $i < $get_users->num_rows(); $i++) {
						$row = $get_users->row_array($i);
						$properties = array("uid","givenname","sn","initials","o","departmentnumber","telephonenumber","mobile","title","physicaldeliveryofficename");
						$filter = "(&(ObjectClass=person)(&(uid=" . $row["user_name"] . ")))";
						$ldap_result = $this->ldap->search(NULL,NULL,$properties,$filter);
						$data['users'][$i] = $ldap_result[0];
					}
				}
			}
			//load view
			array_walk_recursive($data['users'], function (&$value) {
				$value = htmlentities($value);
			});
			$this->load->view("adminpanel/manage_users/index",$data);
		}
		else if($action == "removed") {
			if(is_null($value)) { $data['page_start'] = 0; $data['page'] = 1; }
			else { $data['page'] = $value; $data['page_start'] = (($data['page']-1)*ADMINPANEL_DISPLAY_PER_PAGE);  }
		
			$get_user_count = $this->db->query("SELECT COUNT(user_name) AS count FROM users WHERE user_deleted_flag=1 AND user_is_group=0");
			if($get_user_count) {
				$user_count_arr = $get_user_count->row_array();
				$data['user_count'] = $user_count_arr["count"];
				$get_users = $this->db->query("SELECT user_name FROM (SELECT ROW_NUMBER() OVER (ORDER BY user_name) AS RowNum, user_name,user_deleted_flag,user_is_group FROM users WHERE user_deleted_flag = 1) AS rows WHERE user_deleted_flag=1 AND user_is_group=0 AND RowNum > " . ($data['page_start']) . " AND RowNum <= " . ($data['page_start'] + ADMINPANEL_DISPLAY_PER_PAGE) . " ORDER BY RowNum");
				if($get_users) {
					for($i = 0; $i < $get_users->num_rows(); $i++) {
						$row = $get_users->row_array($i);
						$properties = array("uid","givenname","sn","initials","o","departmentnumber","telephonenumber","mobile","title","physicaldeliveryofficename");
						$filter = "(&(ObjectClass=person)(&(uid=" . $row["user_name"] . ")))";
						$ldap_result = $this->ldap->search(NULL,NULL,$properties,$filter,LDAP_DELETED_ACCOUNTS_DN);
						$data['users'][$i] = $ldap_result[0];
					}
				}
			}
			//load view
			$this->load->view("adminpanel/manage_users/removed",$data);
		}
		else if($action == "user") {
			if(is_null($value)) { show_404(); }
			$data['username'] = $value;
			//check that user value corresponds to valid user
			$get_user = $this->db->query("SELECT user_id,user_name,user_mail,user_ext_notify_flag,user_ext_group_notify_flag  FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($data['username']));
			if($get_user) {
				if($get_user->num_rows() == 1) { 
					$row = $get_user->row_array();
					$properties = array("uid","givenname","sn","initials","o","departmentnumber","telephonenumber","mobile","title","physicaldeliveryofficename",'employeeType');
					$filter = "(&(ObjectClass=person)(&(uid=" . $row["user_name"] . ")))";
					$ldap_result = $this->ldap->search(NULL,NULL,$properties,$filter);
					if(count($ldap_result) == 1) {
						if(isset($ldap_result[0]["givenname"])) { $data['first'] = $ldap_result[0]["givenname"]; } else { $data['first'] = ""; }
						if(isset($ldap_result[0]["sn"])) { $data['last'] = $ldap_result[0]["sn"]; } else { $data['last'] = ""; }
						if(isset($ldap_result[0]["initials"])) { $data['middle'] = $ldap_result[0]["initials"]; } else { $data['middle'] = ""; }
						if(isset($ldap_result[0]["title"])) { $data['jobtitle'] = $ldap_result[0]["title"]; } else { $data['jobtitle'] = ""; }
						if(isset($ldap_result[0]["departmentnumber"])) { $data['department'] = $ldap_result[0]["departmentnumber"]; } else { $data['department'] = ""; }
						if(isset($ldap_result[0]["o"])) { $data['organization'] = $ldap_result[0]["o"]; } else { $data['organization'] = ""; }
						if(isset($ldap_result[0]["telephonenumber"])) { $data['telephone'] = $ldap_result[0]["telephonenumber"]; } else { $data['telephone'] = ""; }
						if(isset($ldap_result[0]["mobile"])) { $data['mobile'] = $ldap_result[0]["mobile"]; } else { $data['mobile'] = ""; }
						if(isset($ldap_result[0]["physicaldeliveryofficename"])) { $data['location'] = $ldap_result[0]["physicaldeliveryofficename"]; } else { $data['location'] = ""; }
						if(isset($ldap_result[0]['employeetype'])) { 
							if($ldap_result[0]['employeetype'] == 'mailboxhidden') { $data['show_personal'] = FALSE; }
							else { $data['show_personal'] = TRUE; }
						}
						else { $data['show_personal'] = TRUE; }
						$group_search = $this->ldap->get_admin_group_membership($ldap_result[0]["dn"]);
						$groups = array();
						for($i = 0; $i < $group_search["count"]; $i++) {
							array_push($groups,$group_search[$i]["dn"]);
						}
						if(in_array(LDAP_ADMIN_GROUP1,$groups)) {
							$data["adminlevel"] = 1;
						}
						else { $data["adminlevel"] = 0; }
					}
					
					if(isset($row["user_mail"])) { $data['ext_mail'] = $row["user_mail"]; } else { $data['ext_mail'] = ""; }
					if(isset($row["user_ext_notify_flag"])) { if($row["user_ext_notify_flag"] == "1") { $data['notify'] = TRUE; } else { $data['notify'] = FALSE; } } else { $data['notify'] = FALSE; }
					if(isset($row['user_ext_group_notify_flag'])) { if($row['user_ext_group_notify_flag'] == '1') { $data['group_notify'] = TRUE; } else { $data['group_notify'] = FALSE; } } else { $data['group_notify'] = FALSE; }
					$this->load->view("adminpanel/manage_users/edit_user",$data);
				}
				else {
					$get_removed_user = $this->db->query("SELECT user_id,user_name,user_mail,user_ext_notify_flag,user_ext_group_notify_flag FROM users WHERE user_deleted_flag=1 AND user_name=" . $this->db->escape($data['username']));
					if($get_removed_user) {
						if($get_removed_user->num_rows() == 1) { 
							$row = $get_removed_user->row_array();
							$properties = array("uid","givenname","sn","initials","o","departmentnumber","telephonenumber","mobile","title","physicaldeliveryofficename",'employeeType');
							$filter = "(&(ObjectClass=person)(&(uid=" . $row["user_name"] . ")))";
							$ldap_result = $this->ldap->search(NULL,NULL,$properties,$filter,LDAP_DELETED_ACCOUNTS_DN);
							if(count($ldap_result) == 1) {
								if(isset($ldap_result[0]["givenname"])) { $data['first'] = $ldap_result[0]["givenname"]; } else { $data['first'] = ""; }
								if(isset($ldap_result[0]["sn"])) { $data['last'] = $ldap_result[0]["sn"]; } else { $data['last'] = ""; }
								if(isset($ldap_result[0]["initials"])) { $data['middle'] = $ldap_result[0]["initials"]; } else { $data['middle'] = ""; }
								if(isset($ldap_result[0]["title"])) { $data['jobtitle'] = $ldap_result[0]["title"]; } else { $data['jobtitle'] = ""; }
								if(isset($ldap_result[0]["departmentnumber"])) { $data['department'] = $ldap_result[0]["departmentnumber"]; } else { $data['department'] = ""; }
								if(isset($ldap_result[0]["o"])) { $data['organization'] = $ldap_result[0]["o"]; } else { $data['organization'] = ""; }
								if(isset($ldap_result[0]["telephonenumber"])) { $data['telephone'] = $ldap_result[0]["telephonenumber"]; } else { $data['telephone'] = ""; }
								if(isset($ldap_result[0]["mobile"])) { $data['mobile'] = $ldap_result[0]["mobile"]; } else { $data['mobile'] = ""; }
								if(isset($ldap_result[0]["physicaldeliveryofficename"])) { $data['location'] = $ldap_result[0]["physicaldeliveryofficename"]; } else { $data['location'] = ""; }
								if(isset($ldap_result[0]['employeetype'])) { 
									if($ldap_result[0]['employeetype'] == 'mailboxhidden') { $data['show_personal'] = FALSE; }
									else { $data['show_personal'] = TRUE; }
								}
								else { $data['show_personal'] = TRUE; }
						
								$group_search = $this->ldap->get_admin_group_membership($ldap_result[0]["dn"]);
								$groups = array();
								for($i = 0; $i < $group_search["count"]; $i++) {
									array_push($groups,$group_search[$i]["dn"]);
								}
								if(in_array(LDAP_ADMIN_GROUP1,$groups)) {
									$data["adminlevel"] = 1;
								}
								else { $data["adminlevel"] = 0; }
							}
							if(isset($row["user_mail"])) { $data['ext_mail'] = $row["user_mail"]; } else { $data['ext_mail'] = ""; }
							if(isset($row["user_ext_notify_flag"])) { if($row["user_ext_notify_flag"] == "1") { $data['notify'] = TRUE; } else { $data['notify'] = FALSE; } } else { $data['notify'] = FALSE; }
							if(isset($row['user_ext_group_notify_flag'])) { if($row['user_ext_group_notify_flag'] == '1') { $data['group_notify'] = TRUE; } else { $data['group_notify'] = FALSE; } } else { $data['group_notify'] = FALSE; }
							$this->load->view("adminpanel/manage_users/edit_removed_user",$data);
						}
					}
				}
			}
			else {
			
			}
		}
		else if($action == "process_request") {
			if(array_key_exists("update",$this->input->post(NULL,TRUE))) { $this->update_information(); }
            else if(array_key_exists("update_removed",$this->input->post(NULL,TRUE))) { $this->update_information(FALSE); }
			else if(array_key_exists("remove",$this->input->post(NULL,TRUE))) { $this->remove_user(); }
			else if(array_key_exists("restore",$this->input->post(NULL,TRUE))) { $this->restore_user(); }
			else if(array_key_exists("create",$this->input->post(NULL,TRUE))) { 
				if($this->create_user()) { redirect("/adminpanel/manage_users/"); } 
				else { 
					$this->session->set_flashdata('form_data',$this->input->post(NULL));
					redirect("/adminpanel/manage_users/create"); 
				}
			}
		}
		else if($action == "create") {
		 	$this->load->view("adminpanel/manage_users/account_creation",$data);
		}
		else { show_404(); }
	}
	
	public function distribution_lists() {
		$this->paginate_distribution_lists(1);
	}
	
	public function paginate_distribution_lists($page) {
		$this->load->model('webmailmodel');
		$this->load->model('public_distribution_list_model','pubdistlist');
		$lists = $this->pubdistlist->find(array());
		$data['list_count'] = count($lists);
		$data['page'] = $page;
		$data['lists'] = array_slice($lists,(($page-1)*ADMINPANEL_DISPLAY_PER_PAGE),ADMINPANEL_DISPLAY_PER_PAGE);
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		$data['title'] = PORTAL_TITLE_PREFIX . 'Admin Panel'; //set title of page
		$this->load->view('adminpanel/manage_lists/index',$data);
	}
	
	public function distribution_lists_removed() {
		$this->paginate_distribution_lists_removed(1);
	}
	
	public function paginate_distribution_lists_removed($page) {
		$this->load->model('webmailmodel');
		$this->load->model('public_distribution_list_model','pubdistlist');
		$lists = $this->pubdistlist->find_deleted(array());
		$data['list_count'] = count($lists);
		$data['page'] = $page;
		$data['lists'] = array_slice($lists,(($page-1)*ADMINPANEL_DISPLAY_PER_PAGE),ADMINPANEL_DISPLAY_PER_PAGE);
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		$data['title'] = PORTAL_TITLE_PREFIX . 'Admin Panel'; //set title of page
		$this->load->view('adminpanel/manage_lists/removed',$data);
	}
	
	//displays the edit form - for save, see edit_distribution_lists()
	public function distribution_lists_edit($id) { 
		$active_tab = '/adminpanel/distribution_lists/' ;
		$form = 'adminpanel/edit_distribution_list';
		$this->_distribution_lists_edit($id, 'public_distribution_list_model', compact('active_tab', 'form'));
	}
	
	//displays the edit form - for save, see distribution_lists_edit_removed()
	public function distribution_lists_edit_removed($id) {
		$active_tab = '/adminpanel/distribution_lists/removed' ;
		$form = 'adminpanel/edit_removed_distribution_list';
		$this->_distribution_lists_edit($id, 'deleted_public_distribution_list_model', compact('active_tab', 'form'));
	}
	
	//helper method to display the edit form for active & removed distros
	protected function _distribution_lists_edit($id, $model, $data) {
		if(!$this->is->nonempty_string($model)) return $this->error->should_be_a_nonempty_string($model);
				
		//first, check to make sure we have a valid list id
		$this->load->model($model,'list_model');
		if(!$this->list_model->formatted_like_an_id($id)) show_404();		
		$list = $this->list_model->find_one(array('id'=>$id));
		if(empty($list)) show_404();
		
		//load data for form
		$this->load->helper("form_helper");
		$this->load->model('webmailmodel');
		
		$data['get_theme'] = $this->webmailmodel->get_user_theme_info();
		$data['title'] = PORTAL_TITLE_PREFIX . 'Admin Panel';
		$data['list_id'] = $id;
		$data['list'] = $list;
		$data['addresses'] = $this->list_model->addresses_for_list($list);
		$data['form_data'] = array('list_display_name' => $list['name'],
								   'list_description' => $list['description']);

		//set up the options for the multiselect
		$user_options = array();
		foreach($this->get_user_search() as $user){
			$email = strtolower(trim($user['id']));
			$user_options[$email] =  $user['name'] . ' ('.$email.')';
		}
		
		$external_addresses = array_diff($data['addresses'], array_keys($user_options));
		foreach($external_addresses as $external_address){
			$user_options[$external_address] = $external_address;
		}
		natcasesort($user_options);		
		$data['user_options'] = $user_options;
		
		$this->load->view('adminpanel/manage_lists/edit_list', $data);
	}
	
	
	public function valid_formatted_address($str)
	{
		$valid_format = (!preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $str)) ? FALSE : TRUE;
		return $valid_format;
	}
	
	/**
	* Displays & submits form to create public distribution lists.
	*/
	public function create_distribution_list() {
		$this->load->library('audit');
		$title = PORTAL_TITLE_PREFIX . 'Admin Panel';
		$form_data = array();
		$validation_errors = array();
		$error = '';
		
		if(!empty($_POST)){
			$list_display_name = $this->input->post('list_display_name',TRUE);
			$list_description = $this->input->post('list_description',TRUE);
				
			//set valdiation rules
			if($this->form_validation->run('distribution_list') === TRUE) {
				$this->load->model('public_distribution_list_model','pubdistlist');
				$attributes = array(
					'name' => $list_display_name,
					'cn' => $list_display_name,
					'description' => $list_description,
				);
				$id = $this->pubdistlist->create($attributes);
				if($this->pubdistlist->formatted_like_an_id($id)){
					$list = $this->pubdistlist->find_one(array('cn'=> $list_display_name));
					$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Created list: ' . $list_display_name. ' ('.$list['id'].')',date('U')));
					redirect('adminpanel/distribution_lists/list/'.$id);
				}else{
					$error = 'Something went wrong and your distribution list was not created.  Please try again in a moment. '.
							 'If you continue to see this error, please contact a site administrator.';
				}
			}
			else {
				//validation fails
				$form_data = $this->input->post(NULL);
				$form_data['list_display_name']=html_entity_decode($form_data['list_display_name'],ENT_QUOTES);
				$form_data['list_description']=html_entity_decode($form_data['list_description'],ENT_QUOTES);
				if(is_array($form_data)) {
					foreach($form_data as $key => $input) {
						if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
					}
					$this->session->set_flashdata('validation_errors',$validation_errors);
				}
			}
		}
		
		$this->load->helper('form_helper');
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$this->load->view('adminpanel/manage_lists/create',compact('error', 'form_data', 'get_theme', 'title', 'validation_errors'));		
	}
	
	/* Form validation callback */
	public function list_is_unique($name) {
		//if we're editing, we could be using the public list model or the deleted list model.  otherwise, it will 
		if(!isset($this->list_model))
			$this->load->model('public_distribution_list_model', 'list_model');
		
		$this->form_validation->set_message('list_is_unique', 'The %s field must not match any existing lists or removed lists.');
		
		$name_is_available = $this->list_model->name_is_available($name);
		if($name_is_available) return true;
			
		//if we're editing (edit_distribution_list or edit_removed_distribution_list), check to see if the name is being used by the list we're editing
		if(string_begins_with('edit', $this->router->method) && string_ends_with('distribution_list', $this->router->method)){
			$list = $this->list_model->find_one(compact('name'));
			return $list['id'] == $this->input->post('list_id');			
		}
		
		return $name_is_available;
	}
	
	// saves the edit form - for the form setup, see distribution_lists_edit()
	public function edit_distribution_list() {
		return $this->_edit_distribution_list('public_distribution_list_model');
	}
	
	// saves the edit form - for the form setup, see distribution_lists_edit_removed()
	public function edit_removed_distribution_list() {
		return $this->_edit_distribution_list('deleted_public_distribution_list_model');
	}
	
	// helper method used by both methods that save edit forms for distros (edit_distribution_list && edit_removed_distribution_list) 
	protected function _edit_distribution_list($model) {
		if(!$this->is->nonempty_string($model)) return $this->error->should_be_a_nonempty_string($model);				
		$this->load->model($model,'list_model');
		
		$list_display_name = $this->input->post('list_display_name',TRUE);
		$list_description = $this->input->post('list_description',TRUE);
		$new_members = $this->input->post('list_members',TRUE);
		if(empty($new_members)) $new_members = array(); //when nothing's selected, we don't always get an array back
		$new_members = array_map('strtolower', $new_members);
		$list_id = $this->input->post('list_id',TRUE);
		
		//set valdiation rules
		if($this->form_validation->run('distribution_list') === TRUE) {
			//update display name and description
			$attributes = array(
				'cn' => $list_display_name,
				'description' => $list_description,
			);
			$this->list_model->update($list_id,$attributes);
			//update addresses
			$old_members = $this->list_model->addresses_for_list($list_id);
			$addresses_to_add = array_diff($new_members,$old_members);
			$addresses_to_remove = array_diff($old_members,$new_members);
			
			foreach($addresses_to_add as $address) {
				 $this->list_model->add_address_to_list($list_id,$address);
			}
			foreach($addresses_to_remove as $address) {
				 $this->list_model->remove_address_from_list($list_id,$address);
			}
		}
		else {
			//validation fails
			$form_data = $this->input->post(NULL);
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				echo json_encode($validation_errors);
			}
		}
	}
	
	public function remove_distribution_list($list_id) {
		$this->load->model('public_distribution_list_model','pubdistlist');
		if($this->pubdistlist->exists($list_id)) {
			$list = $this->pubdistlist->find_one($list_id);
			$this->pubdistlist->delete($list_id);
			$this->load->library('audit');
			if($list !== null){
				$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Removed list: ' . $list['name']. ' ('.$list_id.')',date('U')));
			}
		}
		else { show_404(); }
		redirect('adminpanel/distribution_lists');
	}
	
	public function restore_distribution_list($list_id) {
		$this->load->model('public_distribution_list_model','pubdistlist');
		if($this->pubdistlist->exists_deleted($list_id)) {
			$this->pubdistlist->restore_deleted($list_id);
			$list = $this->pubdistlist->find_one($list_id);
			$this->load->library('audit');
			if($list !== null){
				$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Restored list: ' . $list['name']. ' ('.$list_id.')',date('U')));
			}
		}
		else { show_404(); }
		redirect('adminpanel/distribution_lists/removed');
	}
	
	/* This searches the address book and returns a list of users for use with the search in edit distribution list view */
	private function get_user_search($input = null){  
        $input = urldecode($input);
		$result_arr = array();
		//get addresses from global address book in LDAP
		$ldapconfig['user'] = $this->session->userdata('username');
		$ldapconfig['pwd'] = $this->encrypt->decode($this->session->userdata('ep'));
		$this->load->library('ldap',$ldapconfig);
		$entries = ($this->ldap->search($input));
        $i = 0;
		foreach($entries as $key => $val) {
			if($this->valid_formatted_address($val['mail'])) {
				$contact_arr = array('name'=>(isset($val['displayname'])?$val['displayname']:"Undefined"),'id'=>$val['mail']);
				array_push($result_arr,$contact_arr);
				$i++;
			}
		}
		
		//sort combined result array (natural order, case insensitive)
		usort($result_arr, function( $el1, $el2) { return strnatcasecmp( $el1['name'], $el2['name']); });
		
		//add whatever the user is currently typing so that it is allowed as well
		if($this->valid_formatted_address($input)) {
			$contact_arr = array('name' => $input, 'id' => $input);
			array_push($result_arr,$contact_arr);
		}
		array_walk_recursive($result_arr, function (&$value) {
			$value = htmlentities($value);
		});
		return $result_arr;
	}
	
	/* This function displays the add user to group form view, meant for use with a modal window or pop-up */
	public function add_user_to_group_form($group,$active) {
		$this->load->view('adminpanel/manage_groups/add_user_form',array('group'=>$group,'active'=>$active));
	}
	
	/*This function creates a view with which to view and edit groups
	 */
    public function manage_groups($action = NULL, $value = NULL, $subvalue = NULL) {
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		
		$data['title'] = PORTAL_TITLE_PREFIX . 'Admin Panel'; //set title of page
		//if the action value is null, display the regular manage groups index page (list of all groups)
		if(is_null($action)) { $action = "page"; }
		if($action == "page") {
			if(is_null($value)) { $value = 1; }
			//pull group information from ldap
			if($this->ldap->connected()) {
				$ldap_result = $this->ldap->search(NULL,NULL,array('cn','ou','description'),'(&(ObjectClass=groupofNames))',LDAP_GROUPS_DN);
				$i = 0;
				$groups = array();
				foreach($ldap_result as $result) {
					$groups[$i]['name'] = $result['ou'];
					$groups[$i]['displayname'] = $result['cn'];
					$groups[$i]['description'] = isset($result['description']) ? $result['description'] : '';
					$i++;
				}
				$data['groups'] = array_slice($groups,(($value-1)*ADMINPANEL_DISPLAY_PER_PAGE),ADMINPANEL_DISPLAY_PER_PAGE);
				$data['group_count'] = count($groups);
				$data['page'] = $value;
			}
			array_walk_recursive($data['groups'], function (&$value) {
				$value = htmlentities($value);
			});
			$this->load->view('adminpanel/manage_groups/index',$data); //load index view
		}
		//if action is process request, then we check form input to determine which action to take
		else if($action == "process_request") {
			$this->load->library('audit'); //load audit library for tracking changes to groups
			//add user action
			if(array_key_exists('add_user',$this->input->post(NULL,TRUE))) {
				$group = $this->input->post('group',TRUE);
				$users = $this->input->post('users',TRUE);
				$active = $this->input->post('active',TRUE);
				//check whether we are acting on multiple users (multi-select input or not)
				if(is_array($users)) {
					foreach($users as $user) {
						//add member to group, then log the change if successful
						if($active == 'FALSE') { $dn = LDAP_DELETED_GROUPS_DN; } else { $dn = NULL; }
						if($this->ldap->add_group_membership($group,$user,$dn) !== FALSE) {
							if(!$this->audit->log_event('edit',array($this->get_user_id($user),$this->get_user_id($this->session->userdata('username')),'Add user to group: ' . $group,date('U')))) {
								log_message('error','Failed to audit add user event for user: ' . $user . ' to group: ' . $group);
							}
						}
						//if unsuccessful, see if its due to already existing (other common reasons can be checked for here too) and set error message
						else {
							$ldap_error = strtolower($this->ldap->get_ldap_error());
							$reason = '';
							if(strpos($ldap_error,'exists') !== FALSE) { $reason = ' User is already in group.'; }
							$this->session->set_flashdata('message','Failed to add user: '.$user.' to group.'.$reason);
							$this->session->set_flashdata('message_class','error'); 
						}
					}
				}
				else { 
					//add member to group, then log the change if successful
					if($active == 'FALSE') { $dn = LDAP_DELETED_GROUPS_DN; } else { $dn = NULL; }
					if($this->ldap->add_group_membership($group,$users,$dn) !== FALSE) {
						if(!$this->audit->log_event('edit',array($this->get_user_id($users),$this->get_user_id($this->session->userdata('username')),'Add user to group: ' . $group,date('U')))) {
							log_message('error','Failed to audit add user event for user: ' . $users . ' to group: ' . $group);
						}
					}
					//if unsuccessful, see if its due to already existing (other common reasons can be checked for here too) and set error message
					else {
						$ldap_error = strtolower($this->ldap->get_ldap_error());
						$reason = '';
						if(strpos($ldap_error,'exists') !== FALSE) { $reason = ' User is already in group.'; }
						$this->session->set_flashdata('message','Failed to add user: '.$user.' to group.'.$reason);
						$this->session->set_flashdata('message_class','error'); 
					}
				}
				if($active == 'TRUE') { redirect('adminpanel/manage_groups/group/' . $group); }
				else { 
					redirect('adminpanel/manage_groups/group/removed/' . $group); 
				}
			}
			//remove user action
			else if(array_key_exists('remove_user',$this->input->post(NULL,TRUE))) {
				$group = $this->input->post('group',TRUE);
				$users = $this->input->post('group_users',TRUE);
				$active = $this->input->post('active',TRUE);
				//check whether we are acting on multiple users (multi-select input or not)
				if(is_array($users)) {
					if($active == 'FALSE') { $dn = LDAP_DELETED_GROUPS_DN; } else { $dn = NULL; }
					echo $active;
					foreach($users as $user) {
						if($this->ldap->remove_group_membership($group,$user,$dn)) {
							if(!$this->audit->log_event('edit',array($this->get_user_id($user),$this->get_user_id($this->session->userdata('username')),'Remove user from group: ' . $group,date('U')))) {
								log_message('error','Failed to audit remove user event for user: ' . $user . ' from group: ' . $group);
							}
							if($user == $this->session->userdata('username')) {
								if($this->session->userdata('mailbox_group') == $group) {
									$_SESSION['mailbox'] = 'INBOX';
									$this->session->set_userdata('mailbox_group',$this->session->userdata('username'));
									$this->session->set_userdata('mailbox_group_cn',$this->session->userdata('username'));
								}
							}
						}
						else { 
							$this->session->set_flashdata('message','Failed to remove user: '.$user.' from group.');
							$this->session->set_flashdata('message_class','error');  
						}
					}
				}
				else { 
					if($active == 'FALSE') { $dn = LDAP_DELETED_GROUPS_DN; } else { $dn = NULL; }
					if($this->ldap->remove_group_membership($group,$users,$dn)) {
						if(!$this->audit->log_event('edit',array($this->get_user_id($users),$this->get_user_id($this->session->userdata('username')),'Remove user from group: ' . $group,date('U')))) {
								log_message('error','Failed to audit remove user event for user: ' . $users . ' from group: ' . $group);
						}
						if($users == $this->session->userdata('username')) {
							if($this->session->userdata('mailbox_group') == $group) {
								$_SESSION['mailbox'] = 'INBOX';
								$this->session->set_userdata('mailbox_group',$this->session->userdata('username'));
								$this->session->set_userdata('mailbox_group_cn',$this->session->userdata('username'));
							}
						}
					}
					else { 
						$this->session->set_flashdata('message','Failed to remove user: '.$users.' from group.');
						$this->session->set_flashdata('message_class','error');  
					}
				}
				if($active == 'TRUE') { redirect('adminpanel/manage_groups/group/' . $group); }
				else { redirect('adminpanel/manage_groups/group/removed/' . $group); }
			}
			//if form is to remove the group
			else if(array_key_exists('remove',$this->input->post(NULL,TRUE))) {
				$group = $this->input->post('group',TRUE);
				if($this->ldap->delete_ldap_account($group) !== FALSE && $this->ldap->remove_group($group) !== FALSE) {
					if(!$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Remove group: ' . $group,date('U')))) {
						log_message('error','Failed to audit remove group event for group: ' . $group);
					}
					if($this->session->userdata('mailbox_group') == $group) {
						$_SESSION['mailbox'] = 'INBOX';
						$this->session->set_userdata('mailbox_group',$this->session->userdata('username'));
						$this->session->set_userdata('mailbox_group_cn',$this->session->userdata('username'));
					}
					$this->session->set_flashdata('message_class','success');
					$this->session->set_flashdata('message','Group successfully removed');
					redirect('adminpanel/manage_groups/');
				}
				else {
					$this->session->set_flashdata('message_class','error');
					$this->session->set_flashdata('message','Failed to remove group. '.$this->ldap->get_ldap_error());
					redirect('adminpanel/manage_groups/group/'.$group);
				}
				
			}
			//if form is to restore the group
			else if(array_key_exists('restore',$this->input->post(NULL,TRUE))) {
				$group = $this->input->post('group',TRUE);
				if($this->ldap->restore_group($group) !== FALSE && $this->ldap->restore_ldap_account($group) !== FALSE) {
					if(!$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Restore group: ' . $group,date('U')))) {
						log_message('error','Failed to audit restore group event for group: ' . $group);
					}
					redirect('adminpanel/manage_groups/');
				}
				else {
					$this->session->set_flashdata('message_class','error');
					$this->session->set_flashdata('message','Failed to restore group. '.$this->ldap->get_ldap_error());
					redirect('adminpanel/manage_groups/removed/'.$group);
				}
				
			}
			else if(array_key_exists('update',$this->input->post(NULL,TRUE))) {
				//get form input
				$group = $this->input->post('group',TRUE);
				$group_display_name = $this->input->post('group_display_name',TRUE);
				$group_description = $this->input->post('group_description',TRUE);
				if(array_key_exists('group_notify',$this->input->post(NULL,TRUE))) { $group_notify = TRUE; } else { $group_notify = FALSE; }
				$attributes = array('cn' => $group_display_name, 'description' => $group_description); //set ldap attributes
				
				//set valdiation rules
				$this->form_validation->set_rules('group_display_name','Group Display Name','required');
				$this->form_validation->set_rules('group_description','Group Description','required');
				
				//if the form is being submitted
				if($this->form_validation->run() == true) {
					$update_db = $this->db->query('UPDATE users SET user_ext_notify_flag='.$this->db->escape($group_notify).' WHERE user_name='.$this->db->escape($group));
					if($update_db) { //if db updates, update ldap
						$success = $this->ldap->modify_group($group,$attributes);
						if($success) { 
							$this->session->set_flashdata('message','Updated group information successfully.');
							$this->session->set_flashdata('message_class','success');
							if(!$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Updated group information: ' . $group,date('U')))) {
								log_message('error','Failed to audit update group information for group: ' . $group);
							}
						}
						else { 
							$this->session->set_flashdata('message','Failed to update group.');
							$this->session->set_flashdata('message_class','error');
						}
					}
					else { 
						$this->session->set_flashdata('message','Failed to update group.');
						$this->session->set_flashdata('message_class','error');
					}
					redirect('adminpanel/manage_groups/group/' . $group);
				}
				else {
					//validation fails
					$form_data = $this->input->post(NULL);
					$validation_errors = array();
					if(is_array($form_data)) {
						foreach($form_data as $key => $input) {
							if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
						}
						$this->session->set_flashdata('validation_errors',$validation_errors);
					}
					redirect('adminpanel/manage_groups/group/' . $group);
				}
			}
			else if(array_key_exists('update_removed',$this->input->post(NULL,TRUE))) {
				//get form input
				$group = $this->input->post('group',TRUE);
				$group_display_name = $this->input->post('group_display_name',TRUE);
				$group_description = $this->input->post('group_description',TRUE);
				if(array_key_exists('group_notify',$this->input->post(NULL,TRUE))) { $group_notify = TRUE; } else { $group_notify = FALSE; }
				$attributes = array('cn' => $group_display_name, 'description' => $group_description); //set ldap attributes
				
				//set valdiation rules
				$this->form_validation->set_rules('group_display_name','Group Display Name','required');
				$this->form_validation->set_rules('group_description','Group Description','required');
				
					//if the form is being submitted
					if($this->form_validation->run() == true) {
					$update_db = $this->db->query('UPDATE users SET user_ext_notify_flag='.$this->db->escape($group_notify).' WHERE user_name='.$this->db->escape($group));
					if($update_db) { //if db updates, update ldap
					$success = $this->ldap->modify_group($group,$attributes,LDAP_DELETED_GROUPS_DN);
						if($success) { 
							$this->session->set_flashdata('message','Updated group information successfully.');
							$this->session->set_flashdata('message_class','success');
							if(!$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Updated group information: ' . $group,date('U')))) {
								log_message('error','Failed to audit update group information for group: ' . $group);
							}
						}
						else { 
							$this->session->set_flashdata('message','Failed to update group.');
							$this->session->set_flashdata('message_class','error');
						}
					}
					else { 
						$this->session->set_flashdata('message','Failed to update group.');
						$this->session->set_flashdata('message_class','error');
						
					}
					redirect('adminpanel/manage_groups/group/removed/' . $group);
				}
				else {
					//validation fails
					$form_data = $this->input->post(NULL);
					$validation_errors = array();
					if(is_array($form_data)) {
						foreach($form_data as $key => $input) {
							if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
						}
						$this->session->set_flashdata('validation_errors',$validation_errors);
					}
					redirect('adminpanel/manage_groups/group/removed/' . $group);
				}
			}
		}
		//loads removed users view
		else if($action == 'removed') {
			if(is_null($value)) { $value = 1; }
			//pull group information from ldap
			if($this->ldap->connected()) {
				$ldap_result = $this->ldap->search(NULL,NULL,array('cn','ou','description'),'(&(ObjectClass=groupofNames))',LDAP_DELETED_GROUPS_DN);
				$i = 0;
				$groups = array();
				foreach($ldap_result as $result) {
					$groups[$i]['name'] = $result['ou'];
					$groups[$i]['displayname'] = $result['cn'];
					$groups[$i]['description'] = $result['description'];
					$i++;
				}
				$data['groups'] = array_slice($groups,(($value-1)*ADMINPANEL_DISPLAY_PER_PAGE),ADMINPANEL_DISPLAY_PER_PAGE);
				$data['group_count'] = count($groups);
				$data['page'] = $value;
			}
			$this->load->view('adminpanel/manage_groups/removed',$data);
		}
		//group action, loads group edit view for provided value 
		else if($action == 'group') {
			if(isset($value)) {
				if($value == 'removed') {
					$dn = LDAP_DELETED_GROUPS_DN;
					if(isset($subvalue)) { $group_name = $subvalue; } else { show_404(); }
				}
				else {
					$dn = LDAP_GROUPS_DN;
					$group_name = $value;
				}
				//get group information from ldap
				if($this->ldap->connected()) {
					$ldap_result = $this->ldap->search(NULL,NULL,array('cn','ou','description','member'),'(&(ObjectClass=groupofNames)(ou=' . $group_name . '))',$dn);
					if(count($ldap_result) > 0) { 
						$data['cn'] = $ldap_result[0]['cn'];
						$data['description'] = isset($ldap_result[0]['description']) ? $ldap_result[0]['description'] : '' ;
						$data['members'] = array();
						//get group member info from ldap
						if(is_array($ldap_result[0]['member'])) {
							foreach($ldap_result[0]['member'] as $member) {
								$username = str_replace('uid=','',$member);
								$username = str_replace(','.LDAP_ACCOUNTS_DN,'',$username);
								//check that user value corresponds to valid user
								$get_user = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($username));
								if($get_user) {
									if($get_user->num_rows() == 1) {
										$user_result = $this->ldap->search($username,1,array('displayname','uid'));
										if(count($user_result) > 0) {
											$member = array('displayname' => $user_result[0]['displayname'], 'uid' => $user_result[0]['uid']);
										}
										else { $member = array('displayname' => '', 'uid' => $username); }
										array_push($data['members'],$member);
									}
								}
							}
						}
						$get_ext_email = $this->db->query('SELECT user_ext_notify_flag FROM users WHERE user_name='.$this->db->escape($group_name).' AND user_is_group=1');
						if($get_ext_email) {
							if($get_ext_email->num_rows() == 1) {
								$row = $get_ext_email->row_array();
								$data['group_notify'] = $row['user_ext_notify_flag'];
							}
						}
					}
					else { show_404(); /*if not actual group, show 404*/ }
				}
				$data['group_name'] = $group_name;
				if($value == 'removed') {
					if(isset($subvalue)) {  
						$this->load->view('adminpanel/manage_groups/edit_removed_group',$data); //load view
					}
					else { show_404(); }
				}
				else {
					$this->load->view('adminpanel/manage_groups/edit_group',$data); //load view
				}
			}
			else {
				show_404(); //if not actual group, show 404
			}
		}
		//group create action (loads group creation view if form has not been submitted, processes form if it has)
		else if($action == 'create') {
			$this->load->library('audit'); //load audit library
			//set valdiation rules
			$this->form_validation->set_rules('group_name','Group Name','required|alpha_numeric'); //group name can't contain spaces and must be alphanumeric
			$this->form_validation->set_rules('group_display_name','Group Display Name','required');
			$this->form_validation->set_rules('group_description','Group Description','required');
			//if the form is being submitted
			if($this->form_validation->run() == true) {
				//check if same group already exists in the removed groups dn
				$ldap_result = $this->ldap->search(NULL,NULL,array('dn'),'(&(ObjectClass=groupofNames)(ou=' . $this->input->post('group_name',TRUE) . '))',LDAP_DELETED_GROUPS_DN);
				//only create it if its not already existing, either in the groups dn or deleted groups dn
				if(count($ldap_result) <= 0) { 
					//set attributes for ldap group object
					$attributes['objectclass'] = 'groupOfNames';
					$attributes['member'] = 'cn=admin,' . LDAP_BASE_DOMAIN;
					$attributes['ou'] = $this->input->post('group_name',TRUE);
					$attributes['cn'] = $this->input->post('group_display_name',TRUE);
					$attributes['description'] = $this->input->post('group_description',TRUE);
					//set attributes for ldap group user object (so group information appears in ldap searches for users in global address book
					//and dovecot will deliver mail to the group address)
					$user_attributes["objectClass"] = array('posixAccount', 'top', 'person', 'organizationalPerson', 'inetOrgPerson');
					$user_attributes["gidNumber"] = '5000';
					$user_attributes["uidNumber"] = '5000';
					$user_attributes["uid"] =  $attributes['ou'];
					$user_attributes["homeDirectory"] = '/var/mailboxes/' . strtolower($attributes['ou']);
					$user_attributes["cn"] = $attributes['cn'];
					$user_attributes["displayName"] = $attributes['cn'];
					$user_attributes["givenName"] = $attributes['ou'];
					$user_attributes["sn"] = $attributes['ou'];
					$user_attributes["mail"] = $attributes['ou'] . "@" . DIRECT_DOMAIN;
					//set attributes for database
					$ext_mail = '';
					
					if(!$this->username_exists($attributes['ou'])) {
						//create the group first
						if($this->ldap->create_group($attributes)) { 
							//then create the user account
							if($this->ldap->create_ldap_account($user_attributes)) { 
								//log event
								if(!$this->audit->log_event('edit',array(0,$this->get_user_id($this->session->userdata('username')),'Created group: ' . $attributes['ou'],date('U')))) {
									log_message('error','Failed to audit create group for group: ' . $attributes['ou']);
								}
								$db_attributes = array(
									'username' => $attributes['ou'],
									'ext_mail' => '',
									'pass' => '',
									'actor_id' => $this->get_user_id($this->session->userdata('username')),
									'user_ext_notify_flag' => 1,
									'user_ext_group_notify_flag' => 1,
									'user_deleted_flag' => 0,
									'user_is_group' => 1,
								);
								$create_user_rec = $this->webmailmodel->create_user_record($db_attributes);
								if($create_user_rec) {
									$this->session->set_flashdata('message','Created group successfully.');
									$this->session->set_flashdata('message_class','success');
									
									//initialize group
									$this->initialize_new_group($attributes['ou']);
								}
								else {
									$this->session->set_flashdata('message','Failed to create group user account, contact system administrator.');
									$this->session->set_flashdata('message_class','error');
								}
							}
							//if user account creation fails
							else { 
								$ldap_error = strtolower($this->ldap->get_ldap_error());
								$reason = '';
								if(strpos($ldap_error,'already exists') !== FALSE) { $reason = ' Group user account already exists.'; }
								$this->session->set_flashdata('message','Failed to create group. '.$reason);
								$this->session->set_flashdata('message_class','error');
							}
						}
						//if group creation fails
						else {
							$ldap_error = strtolower($this->ldap->get_ldap_error());
							$reason = '';
							if(strpos($ldap_error,'already exists') !== FALSE) { $reason = ' Group user account already exists.'; }
							$this->session->set_flashdata('message','Failed to create group. '.$reason);
							$this->session->set_flashdata('message_class','error');
						}
					}
					//if group username is taken by regular user
					else {
						$ldap_error = strtolower($this->ldap->get_ldap_error());
						$reason = '';
						if(strpos($ldap_error,'already exists') !== FALSE) { $reason = ' Group already exists.'; }
						$this->session->set_flashdata('message','Failed to create group.'.$reason);
						$this->session->set_flashdata('message_class','error');
					}
				}
				else {
					$this->session->set_flashdata('message','Failed to create group, group name already exists in removed groups.');
					$this->session->set_flashdata('message_class','error');
				}
				redirect('adminpanel/manage_groups');
			}
			//if validation fails or form is not being submitted
			else {
				$form_data = $this->input->post(NULL);
				$data['form_data'] = $form_data;
				$validation_errors = array();
				if(is_array($form_data)) {
					foreach($form_data as $key => $input) {
						if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
					}
					$data['validation_errors'] = $validation_errors;
				}
			 	$this->load->view('adminpanel/manage_groups/create',$data); //load view
			}
		}
		
	}
	
	private function create_user() {
		$this->load->model('webmailmodel');
		$this->form_validation->set_rules("first_name","First Name","required","xss_clean");
		$this->form_validation->set_rules("last_name","Last Name","required","xss_clean");
		$this->form_validation->set_rules("username","Username","required|alpha_numeric","xss_clean");
		
		$edipi_post = $this->input->post('edipi',TRUE);
		$piv_post = $this->input->post('piv',TRUE);
			
		$this->form_validation->set_message('is_natural', 'The %s field must contain only numeric characters.');
		if(!isset($piv_post) || strlen(trim($piv_post)) <= 0) { $this->form_validation->set_rules('edipi','EDIPI','callback_id_required[edipi]|is_natural'); }
		else { $this->form_validation->set_rules('edipi','EDIPI','is_natural'); }
		if(!isset($edipi_post)  || strlen(trim($edipi_post)) <= 0) { $this->form_validation->set_rules('piv','PIV ID','callback_id_required[piv]|is_natural'); }
		else { $this->form_validation->set_rules('piv','PIV ID','is_natural'); }
		
		if($this->form_validation->run() == true) {
			//gather post items into variables
			$username_post = $this->input->post("username",TRUE);
			$first_post = $this->input->post("first_name",TRUE);
			$last_post = $this->input->post("last_name",TRUE);
			$ext_mail_post = $this->input->post("ext_mail",TRUE);
			$middle_post = $this->input->post("middle_name",TRUE);
			$organization_post = $this->input->post("organization",TRUE);
			$department_post = $this->input->post("department",TRUE);
			$telephone_post = $this->input->post("telephone",TRUE);
			$mobile_post = $this->input->post("mobile",TRUE);
			$location_post = $this->input->post("location",TRUE);
			$title_post = $this->input->post("title",TRUE);
			//process required items
			//do piv/edipi id number first
			if((isset($edipi_post) && strlen($edipi_post) > 0) && (isset($piv_post) && strlen($piv_post) > 0)) { $edipi = $edipi_post;  $piv_id = $piv_post; } 
			else if(isset($edipi_post) && strlen($edipi_post) > 0) { $edipi = $edipi_post; }
			else if(isset($piv_post) && strlen($piv_post) > 0) { $piv_id = $piv_post; }
			else { return FALSE; }
			//then do other required items
			if(isset($username_post) && strlen($username_post) > 0) { $username = $username_post; } else { return FALSE; }
			if(isset($first_post) && strlen($first_post) > 0) { $first = $first_post; } else { return FALSE; }
			if(isset($last_post) && strlen($last_post) > 0) { $last = $last_post; } else { return FALSE; }
			//process optional items
			if(isset($ext_mail_post) && strlen($ext_mail_post) > 0) { $ext_mail = $ext_mail_post; } else { $ext_mail = ""; } //this is ext. mail and could be blank in rare cases, so we make it optional and can be manually changed if needed
			if(isset($middle_post) && strlen($middle_post) > 0) { $middle = $middle_post; } else { $middle = NULL;  }
			if(isset($organization_post) && strlen($organization_post) > 0) { $organization = $organization_post; } else { $organization = NULL;  }
			if(isset($department_post) && strlen($department_post) > 0) { $department = $department_post; } else { $department = NULL;  }
			if(isset($telephone_post) && strlen($telephone_post) > 0) { $telephone = $telephone_post; } else { $telephone = NULL;  }
			if(isset($title_post) && strlen($title_post) > 0) { $title = $title_post; } else { $title = NULL;  }
			if(isset($mobile_post) && strlen($mobile_post) > 0) { $mobile = $mobile_post; } else { $mobile = NULL;  }
			if(isset($location_post) && strlen($location_post) > 0) { $location = $location_post; } else { $location = NULL;  }
			//create random password
			$pass = $this->random_password();
			if(isset($pass) && strlen($pass) > 0) { $userpassword = $this->ssha256_encode($pass); } else { return FALSE; }
			if(!isset($userpassword) || !(strlen($userpassword) > 0)) { return FALSE; }
			
			if($this->username_exists($username_post)) { 
				$this->session->set_flashdata('message','Username already exists. User creation failed.');
				$this->session->set_flashdata('message_class','error');
				return FALSE; 
			}
			if($this->edipi_exists($edipi_post)) { 
				$this->session->set_flashdata('message','EDIPI already exists. User creation failed.');
				$this->session->set_flashdata('message_class','error');
				return FALSE; 
			}
			if($this->piv_exists($piv_post)) { 
				$this->session->set_flashdata('message','PIV ID already exists. User creation failed.');
				$this->session->set_flashdata('message_class','error');
				return FALSE; 
			}
			
			if($this->ldap->connected()) {
				$attributes = array();
				$attributes["objectClass"] = array("posixAccount", "top", "person", "organizationalPerson", "inetOrgPerson");
				$attributes["gidNumber"] = "5000";
				$attributes["uidNumber"] = "5000";
				$attributes["uid"] = $username;
				$attributes["homeDirectory"] = "/var/mailboxes/" . $username;
				$attributes["cn"] =($first . " " . $last);
				$attributes["givenName"] = $first;
				$attributes["sn"] = $last;
				$attributes["mail"] = $username . "@" . DIRECT_DOMAIN;
				$attributes["userPassword"] = $userpassword;
				if(!is_null($middle)) { $attributes["initials"] = $middle; $attributes["displayName"] = ($last . ", " . $first . " " . $middle); }
				else { $attributes["displayName"] = ($last . ", " . $first); }
				if(!is_null($department)) { $attributes["departmentNumber"] = $department; }
				if(!is_null($organization)) { $attributes["o"] = $organization; }
				if(!is_null($telephone)) { $attributes["telephoneNumber"] = $telephone; }
				if(!is_null($mobile)) { $attributes["mobile"] = $mobile; }
				if(!is_null($location)) { $attributes["physicaldeliveryofficename"] = $location; }
				if(!is_null($title)) { $attributes["title"] = $title; }
			
				if(!$this->ldap->create_ldap_account($attributes)) { 
					$this->session->set_flashdata('message','Failed to create LDAP account. User creation failed.');
					$this->session->set_flashdata('message_class','error');
					return FALSE; 
				}
			}
			else { return FALSE; }
			$get_actor_id = $this->webmailmodel->get_user_id($this->session->userdata('username'));
			if($get_actor_id && $get_actor_id->num_rows() == 1) {
				$row = $get_actor_id->row_array();
				$actor_id = $row["user_id"];
				$db_attributes = array(
					'edipi' => (isset($edipi)) ? $edipi : '',
					'piv_id' => $piv_id,
					'username' => $username,
					'ext_mail' => $ext_nail,
					'pass' => $pass,
					'actor_id' => $actor_id,
					'user_ext_notify_flag' => 1,
					'user_ext_group_notify_flag' => 0,
					'user_deleted_flag' => 0,
					'user_is_group' => 0,
				);
				$create_user_rec = $this->webmailmodel->create_user_record($db_attributes);
				if($create_user_rec == FALSE) { 
					$this->session->set_flashdata('message','Failed to enter user into database. User creation failed.');
					$this->session->set_flashdata('message_class','error');
					return FALSE; 
				}
				
				
				//if we get to here it should have succeeded, so we log it
				$get_actor_id = $this->webmailmodel->get_user_id($this->session->userdata('username'));
				$get_target_id = $this->webmailmodel->get_user_id($username);
				if($get_actor_id && $get_target_id) {
					$actor_id_row = $get_actor_id->row_array();
					$target_id_row = $get_target_id->row_array();
					$actor_id = $actor_id_row["user_id"];
					$target_id = $target_id_row["user_id"];
					$this->load->library("audit");
					$this->audit->log_event("edit",array($target_id,$actor_id,"Create User",date('U')));
				}
				
				$this->session->set_flashdata('message','Account successfully created.');
				$this->session->set_flashdata('message_class','success');
				redirect('adminpanel/manage_users/');
			}
			else { 
				$this->session->set_flashdata('message','Failed to enter user into database. User creation failed.');
				$this->session->set_flashdata('message_class','error');
				return FALSE; }
		}
		else {
			$form_data = $this->input->post(NULL);
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				$this->session->set_flashdata('validation_errors',$validation_errors);
			}
			return FALSE;
		}
	}
	
	public function id_required($str, $field) {
		switch($field) {
			case 'piv':
				$this->form_validation->set_message('id_required', 'The %s field is required when the EDIPI field is not provided.');
				return (strlen(trim($str)) <= 0) ? FALSE : TRUE;
				break;
			case 'edipi':
				$this->form_validation->set_message('id_required', 'The %s field is required when the PIV ID field is not provided.');
				return (strlen(trim($str)) <= 0) ? FALSE : TRUE;
				break;
			default:
				return FALSE;
				break;
		}
	}
	
	private function remove_user() {
		$uid = $this->input->post("uid",TRUE);
		//check that uid is valid
		if(is_null($uid) || strlen($uid) <= 0) { show_404(); }
		$get_user = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($uid));
		if($get_user && $get_user->num_rows() == 1) { $uid_valid = TRUE; } else { show_404(); }
		//check if its valid, but equal to the current user
		if($uid_valid && $uid == $this->session->userdata("username")) {
			$this->session->set_flashdata('message','Cannot remove logged in user account.');
			$this->session->set_flashdata('message_class','error');
			
			redirect("adminpanel/manage_users/user/" . $uid); //don't let them delete themselves
		}
		//if valid
		if($uid_valid) {
			if($this->ldap->delete_ldap_account($uid)) {
				$update_flag = $this->db->query("UPDATE users SET user_deleted_flag=1 WHERE user_name=" . $this->db->escape($uid));
				if($update_flag) { 
					$get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
					$get_target_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 1 AND user_name=" . $this->db->escape($uid));
					if($get_actor_id && $get_target_id) {
						$actor_id_row = $get_actor_id->row_array();
						$target_id_row = $get_target_id->row_array();
						$actor_id = $actor_id_row["user_id"];
						$target_id = $target_id_row["user_id"];
						$this->load->library("audit");
						$this->audit->log_event("edit",array($target_id,$actor_id,"Remove User",date('U')));
					}
					$this->session->set_flashdata('message','Removed account successfully.');
					$this->session->set_flashdata('message_class','success');
					
					redirect("/adminpanel/manage_users/"); 
				}
				else { 
					$this->session->set_flashdata('message','Removed from LDAP, however, failed to remove account in database. Contact a system administrator for assistance.');
					$this->session->set_flashdata('message_class','error');
					
					redirect("/adminpanel/manage_users/user/" . $uid); 
				}
			}
			else {
				$this->session->set_flashdata('message','Failed to delete account.');
				$this->session->set_flashdata('message_class','error');
	
				redirect("/adminpanel/manage_users/user/" . $uid);
			}
		}
	}

	private function restore_user() {
		$uid = $this->input->post("uid",TRUE);
		//check that uid is valid
		if(is_null($uid) || strlen($uid) <= 0) { show_404(); }
		$get_user = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=1 AND user_name=" . $this->db->escape($uid));
		if($get_user && $get_user->num_rows() == 1) { $uid_valid = TRUE; } else { show_404(); }
		
		//if valid
		if($uid_valid) {
			if($this->ldap->restore_ldap_account($uid)) {
				$update_flag = $this->db->query("UPDATE users SET user_deleted_flag=0 WHERE user_name=" . $this->db->escape($uid));
				if($update_flag) { 
					$get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
					$get_target_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($uid));
					if($get_actor_id && $get_target_id) {
						$actor_id_row = $get_actor_id->row_array();
						$target_id_row = $get_target_id->row_array();
						$actor_id = $actor_id_row["user_id"];
						$target_id = $target_id_row["user_id"];
						$this->load->library("audit");
						$this->audit->log_event("edit",array($target_id,$actor_id,"Remove User",date('U')));
					}
					$this->session->set_flashdata('message','Restored account successfully.');
					$this->session->set_flashdata('message_class','success');
					
					redirect("/adminpanel/manage_users/"); 
					
				}
				else { 
					$this->session->set_flashdata('message','Restored in LDAP, however, failed to restore account in database. Contact a system administrator for assistance.'); 
					$this->session->set_flashdata('message_class','error');
					
					redirect("/adminpanel/manage_users/user/" . $uid); }
			}
			else {
				$this->session->set_flashdata('message','Failed to restore account.'); 
				$this->session->set_flashdata('message_class','error');
				redirect("/adminpanel/manage_users/user/" . $uid);
			}
		}
	}
	
	private function update_information($active_account = TRUE) {
		$this->form_validation->set_rules("first_name","First Name","required","xss_clean");
		$this->form_validation->set_rules("last_name","Last Name","required","xss_clean");
		
		if($this->input->post("confirm_user_pwd",TRUE) == "on")  {
			$this->form_validation->set_rules("user_pwd","User Password","required|matches[reenter_user_pwd]|callback_check_password_strength");
			$this->form_validation->set_rules("reenter_user_pwd","Re-Enter User Password","required|matches[user_pwd]");
		}

		$uid = $this->input->post("uid",TRUE);
		//check that uid is valid
		if(is_null($uid) || strlen($uid) <= 0) { show_404(); }
		$get_user = $this->db->query("SELECT user_name FROM users WHERE user_name=" . $this->db->escape($uid));
		if($get_user && $get_user->num_rows() == 1) { $uid_valid = TRUE; } else { show_404(); }
		
		if($this->form_validation->run() == true && $uid_valid) {
			//capture input for ldap
			$first = $this->input->post("first_name",TRUE);
			$last = $this->input->post("last_name",TRUE);
			$middle = $this->input->post("middle_name",TRUE);
			$title = $this->input->post("title",TRUE);
			$department = $this->input->post("department",TRUE);
			$organization = $this->input->post("organization",TRUE);
			$telephone = $this->input->post("telephone",TRUE);
			$mobile = $this->input->post("mobile",TRUE);
			$location = $this->input->post("location",TRUE);
			$admin_level = $this->input->post("admin_level",TRUE);
			if($this->input->post("confirm_user_pwd",TRUE) == "on")  {
				$user_pwd = $this->input->post("user_pwd",TRUE);
			}
			
			$attributes = array();
			//add mandatory attrs to array
			$attributes["givenName"] = $first;
			$attributes["sn"] = $last;
			$attributes["cn"] = $first . " " . $last;
		
			//deal with optional attributes (middle name is a sepcial case, since we need to change displayName based on it too)
			if(isset($middle) && strlen($middle) > 0) { $attributes["initials"] = $middle; $attributes["displayName"] = $last . ", " . $first . " " . $middle; }
			else { $attributes["displayName"] = $last . ", " . $first; }
			if(isset($title) && strlen($title) > 0) { $attributes["title"] = $title; }
			if(isset($department) && strlen($department) > 0) { $attributes["departmentnumber"] = $department; }
			if(isset($organization) && strlen($organization) > 0) { $attributes["o"] = $organization; }
			if(isset($telephone) && strlen($telephone) > 0) { $attributes["telephonenumber"] = $telephone; }
			if(isset($mobile) && strlen($mobile) > 0) { $attributes["mobile"] = $mobile; }
			if(isset($location) && strlen($location) > 0) { $attributes["physicaldeliveryofficename"] = $location; }
            if(isset($user_pwd) && strlen($user_pwd) > 0) { $attributes["userPassword"] = $this->ssha256_encode($user_pwd); }
			
			//check show/hide personal mailbox
			if(array_key_exists('show_personal',$this->input->post(NULL,TRUE))) { $attributes['employeetype'] = ''; } 
			else { $attributes['employeetype'] = 'mailboxhidden'; }
			
			//check inactive vs. active account for correct dn
            if($active_account) { $dn = LDAP_ACCOUNTS_DN; }
            else { $dn = LDAP_DELETED_ACCOUNTS_DN; }
            
			//modify ldap account with new attributes
			$modified = $this->ldap->modify_ldap_account($uid,$attributes,$dn);
			
			//set admin level
			$group_search = $this->ldap->get_admin_group_membership("uid=" . $uid . "," . $dn);
			$groups = array();
			for($i = 0; $i < $group_search["count"]; $i++) {
				array_push($groups,$group_search[$i]["dn"]);
			}
			if(in_array(LDAP_ADMIN_GROUP1,$groups)) { $prev_admin_level = 1; }
			else { $prev_admin_level = 0; }
			
			if($prev_admin_level != $admin_level) {
				$admin_level_modify = $this->ldap->set_admin_group_membership($uid,$admin_level);
			}
			else { $admin_not_changed = TRUE; }
			
			//capture input for database
			$ext_mail = $this->input->post("ext_mail",TRUE);
			$notify = array_key_exists("notify",$this->input->post(NULL,TRUE));
			$group_notify = array_key_exists('group_notify',$this->input->post(NULL,TRUE));
			//don't update database unless ldap succeeds
			if($modified) {
				if(isset($user_pwd) && strlen($user_pwd) > 0) {
					$update = $this->db->query("UPDATE users SET user_ep=".$this->db->escape($this->encrypt->encode($user_pwd)).",user_mail=" . $this->db->escape($ext_mail).", user_ext_notify_flag=".$this->db->escape($notify).", user_ext_group_notify_flag=".$this->db->escape($group_notify)." WHERE user_name=" . $this->db->escape($uid));
					if($uid == $this->session->userdata('username')) { 
						if($update) { 
							$this->session->set_userdata('ep',$this->encrypt->encode($user_pwd)); //update user pwd in session if its the current user
						}
					}
				}
				else {
					$update = $this->db->query("UPDATE users SET user_mail=".$this->db->escape($ext_mail).", user_ext_notify_flag=".$this->db->escape($notify).", user_ext_group_notify_flag=".$this->db->escape($group_notify)." WHERE user_name=" . $this->db->escape($uid));
				}
				//remove personal notifications to external email if personal mailbox access is turned off
				if($attributes['employeetype'] == 'mailboxhidden') { 
					$update_notifications = $this->db->query("UPDATE users SET user_ext_notify_flag=0 WHERE user_name=".$this->db->escape($uid));
					//if the current user is having their mailbox hidden, update the current session to reflect that
					if($uid == $this->session->userdata('username')) { $this->session->set_userdata('hide_personal_mailbox',TRUE); }
				}
				else {
					//if the current user is having their mailbox unhidden, update the current session to reflect that
					if($uid == $this->session->userdata('username')) { $this->session->set_userdata('hide_personal_mailbox',FALSE); }
				}
			}
			if($modified && $update) {
				$this->load->library('audit');
				
				$message = 'Updated user settings.';
				$this->session->set_flashdata('message',$message);
				$this->session->set_flashdata('message_class','success');
				
				//update cn for logged in user if it is the one being updated
				if($this->session->userdata('username') == $uid) { 
					$this->session->set_userdata('user_cn',$attributes['cn']); //update user's name in session
				}
				//log update for auditing
				$actor_id = $this->get_user_id($this->session->userdata('username'));
				$target_id = $this->get_user_id($uid);
				$this->audit->log_event('edit',array($target_id,$actor_id,'Update user information',date('U')));
				if(!$admin_not_changed) {
					if($admin_level_modify && ($admin_level == 1) && ($prev_admin_level == 0)) {
						$this->session->set_flashdata('message',$message.' '.'Added user as an administrator.');
						$this->session->set_flashdata('message_class','success');
						
						$this->audit->log_event("edit",array($target_id,$actor_id,"Added user to administrators.",date('U')));
					}
					else if($admin_level_modify && ($admin_level == 0) && ($prev_admin_level == 1)) {
						$this->session->set_flashdata('message',$message.' '.'Removed user as an administrator.');
						$this->session->set_flashdata('message_class','success');
						
						$this->audit->log_event("edit",array($target_id,$actor_id,'Removed user from administrators.',date('U')));
					}
					else if(!$admin_level_modify) {
						$this->session->set_flashdata('message','Failed to update user administrative level.');
						$this->session->set_flashdata('message_class','error');
					}
				}
				redirect('/adminpanel/manage_users/user/' . $uid);
			}
			else { 
				$this->session->set_flashdata('message','Failed to update user');
				$this->session->set_flashdata('message_class','error');
				
				redirect('/adminpanel/manage_users/user/' . $uid);
			}
		}
		else { 
			$form_data = $this->input->post(NULL);
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				$this->session->set_flashdata('validation_errors',$validation_errors);
			}
			redirect('/adminpanel/manage_users/user/' . $uid); 
		}
	}
	
	/*This function creates a view with which to view and approve/deny account requests
	 */
	public function account_requests() {
		$this->load->model('webmailmodel');
		$get_theme = $this->webmailmodel->get_user_theme_info();
		$data['get_theme'] = $get_theme;
		
		$data["title"] = PORTAL_TITLE_PREFIX . "Account Requests";
		
		$unapproved = $this->db->query("SELECT * FROM requests WHERE approved_flag = 0 AND denied_flag = 0 ORDER BY request_date ASC");
		if($unapproved) {
			if($unapproved->num_rows() > 0) {
				$view_str = "<table>\n";
				for($i = 0; $i < $unapproved->num_rows(); $i++) {
					$row = $unapproved->row_array($i);
					$view_str .= "<tr><td>\n";
					$view_str .= "<div>\n";
					$view_str .= "<table>\n";
					$view_str .= "<tr><td>Request Date: </td><td>" . date("n/d/Y H:i:s A",$row["request_date"]) . "</td></tr>"; 
					$view_str .= "<tr><td>Name: </td><td>" . $row["last_name"] . ", " . $row["first_name"] . " " . $row["middle_name"] . "</td><td>EDIPI: </td><td>" . ((strlen($row["user_edipi"]) > 0) ? $row["user_edipi"] : 'N/A')  . "</td><td>PIV ID: </td><td>" . ((strlen($row['user_piv_id']) > 0) ? $row['user_piv_id'] : 'N/A') . "</td><td>Suggested Username: </td><td>" . $row["user_name"] . "</td></tr>";
					$view_str .= "<tr><td>Title: </td><td>" . $row["title"] . "</td><td>Department: </td><td>" . $row["department"] . "</td><td>Organization: </td><td>" . $row["organization"] . "</td></tr>";
					$view_str .= "<tr><td>Email: </td><td>" . $row["mail"] . "</td></tr>";
					$view_str .= "</table>\n";
					$view_str .= form_open('/adminpanel/process_request_action')."\n";
					$view_str .= "<div><input type=\"hidden\" name=\"edipi\" value=\"" . $row['user_edipi'] . "\" /><input type=\"hidden\" name=\"piv_id\" value=\"" . $row['user_piv_id'] . "\" /><button type=\"submit\" name=\"approve\">Approve</button><button type=\"submit\" name=\"deny\" onclick=\"javascript:return confirm('Confirm you wish to deny request?');\">Deny</button></div>\n";
					$view_str .= form_close()."\n";
					$view_str .= "</div>\n";
					$view_str .= "</td></tr>\n";
				}
				$view_str .= "</table>\n";
				$data["requests_view"] = $view_str;
			}
		}
		$this->load->view("adminpanel/account_requests",$data);
	}
	public function process_request_action() {
		$approve = array_key_exists("approve",$this->input->post(NULL,TRUE));
		$deny = array_key_exists("deny",$this->input->post(NULL,TRUE));
		if($approve) { $this->approve_request(); }
		if($deny) { $this->deny_request(); }
		redirect("adminpanel/account_requests");
	}
	
	public function ajax_group_member_search($input = NULL,$sizelimit = NULL, $echo = TRUE) {
		if(!is_null($sizelimit)) { $properties = NULL; }
		else {  $properties = array('displayname','objectclass','mail','uid','givenname','initials','sn','physicaldeliveryofficename','o','departmentnumber','mobile','telephonenumber','title');}
		
		//only allow echoing of JSON data if requested with AJAX
		if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&  $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') {
			if($echo) { echo json_encode($this->ldap->search(rawurldecode($input),$sizelimit,$properties,'(&(userPassword=*)(|(displayName='.$input.'*)(uid='.$input.'*)))')); }
		}
		//if not echoing, allow return
		if(!$echo) { return json_encode($this->ldap->search(rawurldecode($input),$sizelimit,$properties,'(&(userPassword=*)(|(displayName='.$input.'*)(uid='.$input.'*)))')); }
	}
	
	public function check_password_strength($password) {
		$valid = TRUE;
		$msg = 'Password strength requirements not met.<br />';
		if(strlen($password) < 15) {
			$msg .= 'Must be at least 15 characters long.<br />';
			$valid = FALSE;
		}
		if(!preg_match("/[a-z]+/", $password)) {
			$msg .= 'Must contain at least one lowercase character.<br />';
			$valid = FALSE;
		}
		if(!preg_match("/[A-Z]+/", $password)) {
			$msg .= 'Must contain at least one uppercase character.<br />';
			$valid = FALSE;
		}
		if(!preg_match("/[0-9]+/", $password)) {
			$msg .= 'Must contain at least one numberic character.<br />';
			$valid = FALSE;
		}
		if(!preg_match("/[!@#$%&*()_+|~=`{}[:;'<>?,.\-\^\]\\\\]+/", $password)) { //four backslashes to escape the backslash once for PHP and once for the regex
			$msg .= 'Must contain at least one special character.<br />';
			$valid = FALSE;
		}
		if(!$valid) { $this->form_validation->set_message('check_password_strength', $msg); }
		return $valid;
	}
	
	private function approve_request() {
		$this->load->model('webmailmodel');
		//get the request data from the database using the DoD ID or VA PIV ID
		$edipi = $this->input->post('edipi',TRUE);
		if(strlen(trim($edipi)) <= 0) { unset($edipi); } //set to null if not provided
		
		$piv_id = $this->input->post('piv_id',TRUE);
		if(strlen(trim($piv_id)) <= 0) { unset($piv_id); } //set to null if not provided
		
		//first check whether EDIPI or PIV ID have been provided
		if(isset($edipi) && strlen(trim($edipi)) > 0) { $edipi_exists = $this->edipi_exists($edipi); }
		if(isset($piv_id) && strlen(trim($piv_id)) > 0) { $piv_exists = $this->piv_exists($piv_id); }
		//next check that both EDIPI and PIV ID are not already in use
		if((isset($edipi_exists) && !$edipi_exists) || ((isset($piv_exists) && !$piv_exists))) {
			if(!isset($edipi)) { 
				$request = $this->db->query("SELECT * FROM requests WHERE (user_piv_id=".$this->db->escape($piv_id).") AND approved_flag = 0 AND created_flag = 0 AND denied_flag = 0");
			}
			else if(!isset($piv_id)) {
				$request = $this->db->query("SELECT * FROM requests WHERE (user_edipi=" . $this->db->escape($edipi) . " AND approved_flag = 0 AND created_flag = 0 AND denied_flag = 0");
			}
			else {
				$request = $this->db->query("SELECT * FROM requests WHERE (user_edipi=" . $this->db->escape($edipi) . " OR user_piv_id=".$this->db->escape($piv_id).") AND approved_flag = 0 AND created_flag = 0 AND denied_flag = 0");
			}
			if($request) {
				if($request->num_rows == 1) {
					$row = $request->row_array();
					//process EDIPI/PIV ID
					$has_edipi = (isset($row['user_edipi']) && strlen($row['user_edipi']) > 0);
					$has_piv = (isset($row['user_piv_id']) && strlen($row['user_piv_id']) > 0);
					if($has_edipi && $has_piv) { $edipi = $row['user_edipi']; $piv_id = $row['user_piv_id']; } 
					else if($has_edipi) { $edipi = $row['user_edipi']; } 
					else if($has_piv) { $piv_id = $row['user_piv_id']; } 
					else { return FALSE; }
					//process other required items
					if(isset($row["user_name"]) && strlen($row["user_name"]) > 0) { $username = $row["user_name"]; } else { return FALSE; }
					if(isset($row["first_name"]) && strlen($row["first_name"]) > 0) { $first = $row["first_name"]; } else { return FALSE; }
					if(isset($row["last_name"]) && strlen($row["last_name"]) > 0) { $last = $row["last_name"]; } else { return FALSE; }
					//process optional items
					if(isset($row["mail"]) && strlen($row["mail"]) > 0) { $ext_mail = $row["mail"]; } else { $ext_mail = ""; } //this is ext. mail and could be blank in rare cases, so we make it optional and can be manually changed if needed
					if(isset($row["middle_name"]) && strlen($row["middle_name"]) > 0) { $middle = $row["middle_name"]; } else { $middle = NULL;  }
					if(isset($row["organization"]) && strlen($row["organization"]) > 0) { $organization = $row["organization"]; } else { $organization = NULL;  }
					if(isset($row["department"]) && strlen($row["department"]) > 0) { $department = $row["department"]; } else { $department = NULL;  }
					if(isset($row["telephone"]) && strlen($row["telephone"]) > 0) { $telephone = $row["telephone"]; } else { $telephone = NULL;  }
					if(isset($row["title"]) && strlen($row["title"]) > 0) { $title = $row["title"]; } else { $title = NULL;  }
					//create random password
					$pass = $this->random_password();
					if(isset($pass) && strlen($pass) > 0) { $userpassword = $this->ssha256_encode($pass); } else { return FALSE; }
					if(!isset($userpassword) || !(strlen($userpassword) > 0)) { return FALSE; }	
				}
				else {
					$this->session->set_flashdata('message','Account approval failed. Failed to retrieve request data.');
					$this->session->set_flashdata('message_class','error');
					return FALSE; 
				}
			}
			else {
				$this->session->set_flashdata('message','Account approval failed. Failed to retrieve request data.');
				$this->session->set_flashdata('message_class','error');
				return FALSE; 
			}
			if($this->ldap->connected()) {
				$attributes = array();
				$attributes["objectClass"] = array("posixAccount", "top", "person", "organizationalPerson", "inetOrgPerson");
				$attributes["gidNumber"] = "5000";
				$attributes["uidNumber"] = "5000";
				$attributes["uid"] = $username;
				$attributes["homeDirectory"] = "/var/mailboxes/" . $username;
				$attributes["cn"] =($first . " " . $last);
				$attributes["givenName"] = $first;
				$attributes["sn"] = $last;
				$attributes["mail"] = $username . "@" . DIRECT_DOMAIN;
				$attributes["userPassword"] = $userpassword;
				if(!is_null($middle)) { $attributes["initials"] = $middle; $attributes["displayName"] = ($last . ", " . $first . " " . $middle); }
				else { $attributes["displayName"] = ($last . ", " . $first); }
				if(!is_null($department)) { $attributes["departmentNumber"] = $department; }
				if(!is_null($organization)) { $attributes["o"] = $organization; }
				if(!is_null($telephone)) { $attributes["telephoneNumber"] = $telephone; }
				if(!is_null($title)) { $attributes["title"] = $title; }
			
				if(!$this->ldap->create_ldap_account($attributes)) { 
					$this->session->set_flashdata('message','Account approval failed. Failed to create user account in LDAP.');
					$this->session->set_flashdata('message_class','error');
					return FALSE; 
				}
			}
			else {
				$this->session->set_flashdata('message','Account approval failed. Failed to create user account in LDAP.');
				$this->session->set_flashdata('message_class','error');
				return FALSE; 
			}
			$get_actor_id = $this->webmailmodel->get_user_id($this->session->userdata('username'));
			if($get_actor_id && $get_actor_id->num_rows() == 1) {
				$row = $get_actor_id->row_array();
				$actor_id = $row['user_id'];
				$db_attributes = array(
					'edipi' => $edipi,
					'piv_id' => $piv_id,
					'username' => $username,
					'ext_mail' => $ext_nail,
					'pass' => $pass,
					'actor_id' => $actor_id,
					'user_ext_notify_flag' => 1,
					'user_ext_group_notify_flag' => 0,
					'user_deleted_flag' => 0,
					'user_is_group' => 0,
				);
				$create_user_rec = $this->webmailmodel->create_user_record($db_attributes);
				if($create_user_rec) {
					if($has_edipi) {
						$close_request = $this->db->query("UPDATE requests SET approved_flag = 1, created_flag = 1 WHERE user_edipi=" . $this->db->escape($edipi));
					}
					else if($has_piv) {
						$close_request = $this->db->query("UPDATE requests SET approved_flag = 1, created_flag = 1 WHERE user_piv_id=" . $this->db->escape($piv_id));
					}
					$this->session->set_flashdata('message','Account approved, account created successfully.');
					$this->session->set_flashdata('message_class','success');
				}
				else {
					$this->session->set_flashdata('message','Account approval failed. Failed to create user account.');
					$this->session->set_flashdata('message_class','error');
					return FALSE; 
				}
			}
			else {
				$this->session->set_flashdata('message','Account approval failed. Failed to create user account.');
				$this->session->set_flashdata('message_class','error');
				return FALSE; 
			}
		}
		else {
			//if EDIPI/PIV ID already exists somewhere
			if((isset($edipi_exists) && $edipi_exists) && (isset($piv_exists) && $piv_exists)) {
				$this->session->set_flashdata('message','Both EDIPI and PIV ID for this request already registered with the system. If user has a deactivated account, restore from "Manage Removed Users" screen.');
			}
			else if((isset($edipi_exists) && $edipi_exists)) {
				$this->session->set_flashdata('message','EDIPI for this request already registered with the system. If user has a deactivated account, restore from "Manage Removed Users" screen.');
			}
			else if((isset($piv_exists) && $piv_exists)) {
				$this->session->set_flashdata('message','PIV ID for this request already registered with the system. If user has a deactivated account, restore from "Manage Removed Users" screen.');
			}
			else {
				$this->session->set_flashdata('message','Failed to create user account due to credentials already being in use.');
			}
			$this->session->set_flashdata('message_class','error');
			return FALSE;
		}
	}
	
	private function deny_request() {
		$edipi = $this->input->post("id",TRUE);
		$deny_request = $this->db->query("UPDATE requests SET denied_flag = 1 WHERE user_edipi=" . $this->db->escape($edipi));
		if($deny_request) { 
			$this->session->set_flashdata('message','Account request denied.');
			$this->session->set_flashdata('message_class','success');
			return TRUE; 
		}
		else {
			$this->session->set_flashdata('message','Account request denial failed.');
			$this->session->set_flashdata('message_class','error');
			return FALSE; 
		}
	}
	
	private function random_password() {
		$chars = array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","1","2","3","4","5","6","7","8","9","0","!","@","#","$","%","^","&","*","(",")","{","}","?");
		$pass = "";
		for($i = 0; $i < 32; $i++) {
			$pass .= $chars[array_rand($chars)];
		}
		return $pass;
	}
	
	private function ssha256_encode($text) {
		$salt = hash('sha256', openssl_random_pseudo_bytes(32));
		$hash = "{SSHA256}".base64_encode(pack("H*",hash('sha256',$text.$salt)).$salt);
		return $hash;
	}
	
	/* This function simply checks if a username exists in the database in created or request processing users. Checks everything, including deleted users.
	 * It returns TRUE if the username exists and FALSE if it does not.
	 */
	private function username_exists($username) {
		$this->load->database();
		$username_check = $this->db->query("SELECT users.user_name FROM users LEFT JOIN requests ON (requests.user_name = users.user_name) WHERE users.user_name=" . $this->db->escape($username) . " OR (requests.user_name=" . $this->db->escape($username) .  " AND requests.approved_flag = 0 AND requests.denied_flag = 0)");
		if($username_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
	
	/* This function simply checks if an EDIPI exists in the database in created users. Checks everything, including deleted users.
	 * It returns TRUE if the EDIPI exists and FALSE if it does not.
	 */
	private function edipi_exists($edipi) {
		if(!isset($edipi) || strlen($edipi) <= 0) { return FALSE; } //blank edipis don't "exist"
		$this->load->database();
		$edipi_check = $this->db->query('SELECT user_edipi FROM users WHERE user_edipi=' . $this->db->escape($edipi) . ' AND user_edipi IS NOT NULL');
		if($edipi_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
	
	/* This function simply checks if a PIV ID exists in the database in created users. Checks everything, including deleted users.
	 * It returns TRUE if the PIV ID exists and FALSE if it does not.
	 */
	private function piv_exists($piv_id) {
		if(!isset($piv_id) || strlen($piv_id) <= 0) { return FALSE; } //blank piv ids don't "exist"
		$this->load->database();
		$piv_check = $this->db->query('SELECT user_piv_id FROM users WHERE user_piv_id=' . $this->db->escape($piv_id) . ' AND user_piv_id IS NOT NULL');
		if($piv_check->num_rows() > 0) { return TRUE; }
		else { return FALSE; }
	}
	
	/* This function takes inputs and uses them to create a table which can then be transformed by the jQuery visualization
	 * library.
	 */
	private function createJQueryChart($chartType, $caption, $data, $id, $width="325px", $height="100px", $colors="['red']", $visualize=TRUE) {
		$chart_table = "<table class=\"chart\" id=\"" . $id . "\" style=\"width: " . $width ."; height: " . $height . ";\">\n";
		$chart_table .= "<caption>" . $caption . "</caption>\n";
		$chart_table .= "<tbody>\n";
		if($chartType != "table") { $chart_table .= "<thead>\n"; }
		$i = 0;
		foreach($data as $row) {
			if($i == 0 && $chartType != "table") { $chart_table .= "<tr>\n"; }
			$j = 0;
			foreach($row as $col) {
				if($j == 0 && $chartType != "table") { $chart_table .= "<th scope=\"col\">" .  $col . "</th>\n"; }
				$j++;
			}
			if($i+1 == count($data) && $chartType != "table") { $chart_table .= "</tr>\n"; }
			$i++;
		}
		if($chartType != "table") { $chart_table .= "</thead>\n"; }
		$i = 0;
		foreach($data as $row) {
			if($i == 0 || $chartType == "pie" || $chartType == "table") { $chart_table .= "<tr>\n"; }
			$j = 0;
			foreach($row as $col) {
				if($j != 0) { $chart_table .= "<td>" .  $col . "</td>\n"; }
				else if(($chartType == "pie" || $chartType == "table") && $j == 0) { $chart_table .= "<th scope=\"row\">" .  $col . "</th>\n";}
				$j++;
			}
			if($i+1 == count($data) || $chartType == "pie" || $chartType == "table") { $chart_table .= "</tr>\n"; }
			$i++;
		}
		$chart_table .= "</tbody>\n";
		$chart_table .= "</table>\n";
		if($visualize == TRUE) {
			$chart_table .= "<script>
			$(document).ready(
				function() { $('#" . $id . "').css('display','none');
				$('#" . $id . "').visualize({type: '" .$chartType . "', width: '" . $width . "', height: '" .$height. "', colors: ". $colors ."}); }
			);
			</script>\n";
		}
		return $chart_table; 
	}
	
	/* This function takes inputs and creates the javascript necessary for generating a chart using the Google Charts API.
	 * Unfortunately this does require contact with the google API, and therefore will not be of much use.
	 */
	private function createGoogleChart($chartType, $options, $columns, $data, $div_name) {
		$chart_script = 
		"<script type=\"text/javascript\">
			google.load(\"visualization\", \"1\", {packages:[\"corechart\"]});
			google.setOnLoadCallback(drawChart);
			function drawChart() {
			var data = new google.visualization.DataTable();\n";
			foreach($columns as $column) {
				$chart_script .= "\ndata.addColumn('". $column['datatype'] . "', '" . $column['val'] . "');";
			}
			$chart_script .= "\ndata.addRows([";
			$i = 0;
			foreach($data as $row) {
				$chart_script .= "[";
				$j = 0;
				foreach($row as $col) {
					if($columns[$j]["datatype"] == "string") { $chart_script .= ($j+1 == count($row)) ? "'" . $col . "'": "'" . $col . "',"; }
					else { $chart_script .= ($j+1 == count($row)) ? $col : $col . ","; }
					$j++;
				}
				if($i+1 == count($data)) { $chart_script .= "]"; }
					else { $chart_script .= "],"; }
				$i++;
			}
			$chart_script .= "]);\n";
			$chart_script .= "var options = " . $options . ";\n";
	
			$chart_script .= "var chart = new google.visualization." .$chartType . "(document.getElementById('" . $div_name . "'));
				chart.draw(data, options);\n
			}
			</script>";
			return $chart_script;
	}
	
	private function get_user_id($username) {
		$get_id = $this->db->query('SELECT user_id FROM users WHERE user_name=' . $this->db->escape($username));
		if($get_id && $get_id->num_rows() == 1) {
			$get_id_row = $get_id->row_array();
			return $get_id_row['user_id'];
		}
		return FALSE;
	}
	
	private function get_user_timezone() {
		$this->load->database();
		$this->load->library('locale');
		$locale_query = $this->db->query('SELECT user_locale FROM users WHERE user_name='.$this->db->escape($this->session->userdata('username')));
		if($locale_query) {
			$locale = $locale_query->row_array();
			$locale = unserialize($locale['user_locale']);
			return $this->locale->get_timezone_from_id($locale['timezone']);
		}
		return FALSE;
	}
	
	private function generate_pagination($page,$items,$items_per_page,$link) {
		$view_str = '<h3 class="hidden_context">Pagination</h3>';
		if($items > $items_per_page) {
			$view_str .= "<div id=\"pagination\">\n";
			if($items%$items_per_page > 0) { $page_count = (int)($items/$items_per_page)+1; }
			else { $page_count = (int)($items/$items_per_page); }
			//style pagination
			$before_span = 5;
			$after_span = 5;
			if($page - 5 <= 0) { $after_span += abs($page - $before_span); }
			else if($page + 5 > $page_count) { $before_span += abs($page_count - ($page + $after_span)); }
			for($i = ($page - $before_span); $i <= ($page+$after_span); $i++) {
				if($i > 0 && $i <= $page_count) {
					if($i == ($page - $before_span) && ($page - $before_span > 1)) { $view_str .= '<a style="margin-right: 3px;" href="' . $link . ($page - 1). '"><img src="/images/lt.png" alt="Previous Page"></a>'; }
					if(($i) != $page) { $view_str .= '<a href="' . $link . ($i) . '">' . ($i) . '</a> '; }
					else {  $view_str .= "<span style=\"padding: 2px; font-weight: bold;\">" . ($i) . '</span>'; }
					if($i == ($page+$after_span) && ($page+$after_span < $page_count)) { $view_str .= '<a href="' . $link . ($page + 1). '"><img src="/images/gt.png" alt="Next Page"></a>'; }
				}
			}
			$view_str .= "</div>\n";
		}
		return $view_str;
	}
	
	/* This function initializes a new group in dovecot by adding a user to the group, performing an IMAP action to run the post-login script
	 * that will create the group mailboxes, then sends a message to the group to generate the sieve script that will file all future messages
	 * into the public group mailboxes rather than the private user mailbox associated with the group.
	 */
	private function initialize_new_group($group) {
		$this->load->library('ldap');
		$this->load->library('email');
		
		//mail configuration items
        $mailconfig = 	array(
							'useragent' => DIRECT_USERAGENT,
							'smtp_host' => SMTP_HOSTNAME,
							'smtp_port' => SMTP_PORT,
							'smtp_user' => $this->session->userdata('username'),
							'smtp_pass' => $this->encrypt->decode($this->session->userdata('ep')),
							'protocol' => DIRECT_SEND_PROTOCOL,
							'smtp_timeout' => SMTP_TIMEOUT,
						);
						
        $this->email->initialize($mailconfig);
        $this->email->set_newline("\r\n");
		$this->email->from($mailconfig['smtp_user'].'@'.DIRECT_DOMAIN, 'Automated Group Creation');
		$this->email->to($group.'@'.DIRECT_DOMAIN);
		$this->email->subject('Automated Group Creation Message');
		$this->email->message('Automated message to create group mailbox.');
		
		//add curent user to the group
		$this->ldap->add_group_membership($group,$this->session->userdata('username'));
			
		$connection = imap_open("{".IMAP_HOSTNAME.":".IMAP_PORT. IMAP_SERVICEFLAGS .'}'.GROUP_MAILBOX_PREFIX.'.'.$group.'.INBOX', $mailconfig['smtp_user'], $mailconfig['smtp_pass'],NULL,1);
		imap_close($connection);
		$this->email->send();
		$connection = imap_open("{".IMAP_HOSTNAME.":".IMAP_PORT. IMAP_SERVICEFLAGS .'}'.GROUP_MAILBOX_PREFIX.'.'.$group.'.INBOX', $mailconfig['smtp_user'], $mailconfig['smtp_pass'],NULL,1);
		imap_close($connection);
	
		//remove current user from the group
		$this->ldap->remove_group_membership($group,$this->session->userdata('username'));
	}
	private function sanatize_export($input){
		return str_replace("\"","\"\"",str_replace(array("\r","\n"),"",$input));
	}
}

/* End of file adminpanel.php */
/* Location: ./application/controllers/adminpanel.php */
